package org.jboss.test.jbossnet.jmx.server;

/**
 * A test mbean that will be provided as a web-service
 * @jmx.mbean name="jboss.net:service=JMXTestMBean"
 * @jboss-net.web-service urn="JMXTest"
 * @author braswell
 * @author jung
 * @version $Revision: 1.1.1.1.4.1 $
 * @since long ago
 */

public class JMXTest implements JMXTestMBean
{

   /**
    * Method getTestString
    * @jmx.managed-attribute
    * @jboss-net.web-method
    * @return
    */

   public String getTestString()
   {
      return testString;
   }

   /**
    * Method setTestString
    * @jmx.managed-attribute
    * @jboss-net.web-method
    * @param str
    */

   public void setTestString(String str)
   {
      testString = str;
   }

   /**
    * Method noopOperation
    * @jmx.managed-operation
    * @jboss-net.web-method
    */

   public void noopOperation()
   {
      /* doing nothing */
   }

   /* Member variables */
   private String testString = "JMX_TEST_STRING";

}
