/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.jbossnet.message;

// $Id: MessageTestCase.java,v 1.1.4.1 2004/11/05 22:35:03 tdiesler Exp $

import junit.framework.Test;
import org.apache.axis.utils.DOM2Utils;
import org.jboss.test.JBossTestCase;
import org.jboss.test.jbossnet.JBossNetTestBase;
import org.w3c.dom.Document;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import java.io.ByteArrayInputStream;
import java.net.URL;

/** 
 * Endpoint test for document centric message exchange .
 * It uses the the jva:MSG provider.
 *
 * @author Thomas.Diesler@jboss.org
 */
public class MessageTestCase extends JBossNetTestBase
{
   public static final String xmlstr = "<root><child>Hello</child><child>World</child></root>";

   public MessageTestCase(String name)
   {
      super(name);
   }

   /** Process an Document at the endpoint
    */
   public void testProcessMessage() throws Exception
   {
      DocumentBuilder builder = DOM2Utils.getDocumentBuilder();
      Document doc = builder.parse(new ByteArrayInputStream(xmlstr.getBytes()));

      String namespaceURI = "http://jboss.net/message";
      URL wsdlURL = new URL(SERVICES_LOCATION + "/MessageServer?wsdl");
      Service service = createService(wsdlURL, new QName(namespaceURI, "MessageServerService"));
      Call call = service.createCall(new QName(namespaceURI, "MessageServer"), "processMessage");

      Object retObj = call.invoke(new Object[]{doc});
      assertNotNull("Return obj is null", retObj);
   }

   /** Deploy the test ear */
   public static Test suite() throws Exception
   {
      return getDeploySetup(MessageTestCase.class, "jbossnet-message.wsr");
   }

}
