/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
 
package org.jboss.test.jbossnet.security.server;

import org.jboss.test.util.ejb.SessionSupport;

/**
 * Secured session bean to test web service authentication. Please ensure that
 * you have copied user.properties and role.properties from the 
 * security testsuite to your server configuration directory.
 * @author jung
 * @version $Revision: 1.1.1.1.4.4 $
 * @ejb.bean name="Authentication"
 *           display-name="Authentication Bean"
 *           type="Stateless"
 *           view-type="remote"
 *           jndi-name="security/Authentication"
 * @ejb.interface remote-class="org.jboss.test.jbossnet.security.Authentication" extends="javax.ejb.EJBObject"
 * @ejb.home remote-class="org.jboss.test.jbossnet.security.AuthenticationHome" extends="javax.ejb.EJBHome"
 * @ejb.permission role-name="Role2"
 * @ejb.transaction type="Required"
 * @jboss-net.web-service urn="Authentication"
 * @jboss-net.authentication domain="jbossnet-tests"
 */

public class AuthenticationBean
   extends SessionSupport implements javax.ejb.SessionBean
{
   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="remote"
    */
   
   public boolean workedOut()
   {
      // return true if role1 is logged in
      return sessionCtx.isCallerInRole("Role1");
   }

}
