/*
 * Created on 12.11.2003
 *
 * To change the template for this generated file go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
package org.jboss.test.jbossnet.security.server;

import java.security.acl.Group;
/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

// $Id: TestLoginModule.java,v 1.1.1.1.4.1 2004/08/09 09:54:39 tdiesler Exp $

import javax.security.auth.login.LoginException;

import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;

/**
 * Alternate login module for replacing the other domain
 * @author jung
 * @since 12.11.03
 */
public class TestLoginModule extends UsernamePasswordLoginModule
{

   /* (non-Javadoc)
    * @see org.jboss.security.auth.spi.UsernamePasswordLoginModule#getUsersPassword()
    */
   protected String getUsersPassword() throws LoginException
   {
      if ("jduke".equals(getUsername()))
      {
         return "theduke";
      } else if ("jdukeman".equals(getUsername()))
      {
         return "anotherduke";
      }
      return null;
   }

   /* (non-Javadoc)
    * @see org.jboss.security.auth.spi.AbstractServerLoginModule#getRoleSets()
    */
   protected Group[] getRoleSets() throws LoginException
   {
      SimpleGroup roles = new SimpleGroup("Roles");

      if ("jduke".equals(getUsername()))
      {
         roles.addMember(new SimplePrincipal("orb.jboss.net.Administrator"));
         roles.addMember(new SimplePrincipal("Role1"));
         roles.addMember(new SimplePrincipal("Role2"));
      } else if ("jdukeman".equals(getUsername()))
      {
         roles.addMember(new SimplePrincipal("Role2"));
         roles.addMember(new SimplePrincipal("Role3"));
      }

      return new Group[] { roles };
   }

}
