/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
 
package org.jboss.test.jbossnet.state.server;

import org.jboss.test.util.ejb.SessionSupport;

/**
 * Stateful web service to test application-level scoping.
 * @author jung
 * @version $Revision: 1.1.1.1.4.1 $
 * @ejb.bean name="FullState"
 *           display-name="Appication-level Stateful Count Bean"
 *           type="Stateful"
 *           view-type="remote"
 *           jndi-name="state/FullState"
 * @ejb.interface remote-class="org.jboss.test.jbossnet.state.FullState" extends="javax.ejb.EJBObject"
 * @ejb.home remote-class="org.jboss.test.jbossnet.state.FullStateHome" extends="javax.ejb.EJBHome"
 * @ejb.transaction type="Required"
 * @jboss-net.web-service urn="FullState" scope="Application"
 */

public class FullStateBean
   extends SessionSupport implements javax.ejb.SessionBean
{
   protected int count=0;

   /** restore count upon pooling */
   public void ejbCreate() {
   	count=0;
   }

   /**
    * @jboss-net.web-method
    * @ejb.interface-method view-type="remote"
    */
   
   public int count() 
   {
      return count++;
   }
}
