/*
 * JBoss, the OpenSource WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 *
 */
package org.jboss.test.jca.test;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jboss.test.JBossTestCase;
import org.jboss.test.jca.interfaces.CachedConnectionSessionHome;
import org.jboss.test.jca.interfaces.CachedConnectionSession;
import org.jboss.test.jca.interfaces.PreparedStatementHome;
import org.jboss.test.jca.interfaces.PreparedStatementRemote;

import javax.management.ObjectName;
import javax.management.Attribute;
import javax.naming.InitialContext;

/** Tests of the prepared statement cache.
 *
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1 $
 */
public class PSCacheUnitTestCase extends JBossTestCase
{
   public PSCacheUnitTestCase (String name)
   {
      super(name);
   }

   public void testBasic() throws Exception
   {
      InitialContext ctx = new InitialContext();
      PreparedStatementHome home = (PreparedStatementHome) ctx.lookup("PreparedStatementBean");
      PreparedStatementRemote bean = home.create("key1", "name1");
      bean.hashEntityTable();
      bean.remove();
   }

   public static Test suite() throws Exception
   {
      return getDeploySetup(PSCacheUnitTestCase.class, "pscache.jar");
   }
}
