/*
 * JBoss, the OpenSource J2EE WebOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.security.ejb;

import java.security.acl.Group;
import java.security.Principal;
import javax.security.auth.login.LoginException;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

/** Test of installing a custom principal via a login module.
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.1 $
 */
public class CustomPrincipalLoginModule extends UsernamePasswordLoginModule
{
   private CustomPrincipalImpl caller;

   public boolean login() throws LoginException
   {
      if (super.login())
      {
         caller = new CustomPrincipalImpl(getUsername());
         return true;
      }
      return false;
   }

   protected Principal getIdentity()
   {
      Principal identity = caller;
      if( identity == null )
         identity = super.getIdentity();
      return identity;
   }

   protected Group[] getRoleSets() throws LoginException
   {
      try
      {
         // The declarative permissions
         Group roles = new SimpleGroup("Roles");
         // The caller identity
         Group callerPrincipal = new SimpleGroup("CallerPrincipal");
         Group[] groups = {roles, callerPrincipal};
         log.info("Getting roles for user=" + getUsername());
         // Add the Echo role
         roles.addMember(new SimplePrincipal("Echo"));
         // Add the custom principal for the caller
         callerPrincipal.addMember(caller);
         return groups;
      }
      catch (Exception e)
      {
         log.error("Failed to obtain groups for user=" + getUsername(), e);
         throw new LoginException(e.toString());
      }
   }

   protected String getUsersPassword()
   {
      return "theduke";
   }

}