/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.security.test;

import java.util.Arrays;
import java.io.File;
import java.io.FileWriter;
import javax.management.ObjectName;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKey;
import javax.crypto.Cipher;

import org.jboss.test.JBossTestCase;
import org.jboss.test.JBossTestSetup;
import org.jboss.security.plugins.FilePassword;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;


/** Tests of the JaasSecurityDomain service.
 
 @author Scott.Stark@jboss.org
 @version $Revision: 1.1.2.2 $
 */
public class JaasSecurityDomainUnitTestCase
   extends JBossTestCase
{
   public JaasSecurityDomainUnitTestCase(String name)
   {
      super(name);
   }

   public void testTmpFilePassword() throws Exception
   {
      ObjectName name = new ObjectName("jboss.security:service=JaasSecurityDomain,domain=testTmpFilePassword");
      byte[] secret = "secret".getBytes();
      Object[] args = {secret};
      String[] sig = {secret.getClass().getName()};
      byte[] encode = (byte[]) super.invoke(name, "encode", args, sig);
      assertTrue("secret != encode", Arrays.equals(secret, encode) == false);

      PBEParameterSpec cipherSpec = new PBEParameterSpec("abcdefgh".getBytes(), 13);
      PBEKeySpec keySpec = new PBEKeySpec("password1".toCharArray());
      SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
      SecretKey cipherKey = factory.generateSecret(keySpec);
      Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
      cipher.init(Cipher.DECRYPT_MODE, cipherKey, cipherSpec);
      byte[] decode = cipher.doFinal(encode);
      assertTrue("secret == decode", Arrays.equals(secret, decode));
   }

   public void testFilePassword() throws Exception
   {
      ObjectName name = new ObjectName("jboss.security:service=JaasSecurityDomain,domain=testFilePassword");
      byte[] secret = "secret".getBytes();
      Object[] args = {secret};
      String[] sig = {secret.getClass().getName()};
      byte[] encode = (byte[]) super.invoke(name, "encode", args, sig);
      assertTrue("secret != encode", Arrays.equals(secret, encode) == false);

      PBEParameterSpec cipherSpec = new PBEParameterSpec("abcdefgh".getBytes(), 13);
      PBEKeySpec keySpec = new PBEKeySpec("password2".toCharArray());
      SecretKeyFactory factory = SecretKeyFactory.getInstance("PBEwithMD5andDES");
      SecretKey cipherKey = factory.generateSecret(keySpec);
      Cipher cipher = Cipher.getInstance("PBEwithMD5andDES");
      cipher.init(Cipher.DECRYPT_MODE, cipherKey, cipherSpec);
      byte[] decode = cipher.doFinal(encode);
      assertTrue("secret == decode", Arrays.equals(secret, decode));
   }

   public void testEncodeDecode() throws Exception
   {
      ObjectName name = new ObjectName("jboss.security:service=JaasSecurityDomain,domain=encode-decode");
      byte[] secret = "secret".getBytes();
      Object[] args = {secret};
      String[] sig = {secret.getClass().getName()};
      byte[] encode = (byte[]) super.invoke(name, "encode", args, sig);
      assertTrue("secret != encode", Arrays.equals(secret, encode) == false);
      args = new Object[]{encode};
      byte[] decode = (byte[]) super.invoke(name, "decode", args, sig);
      assertTrue("secret == decode", Arrays.equals(secret, decode));
   }
   public void testEncodeDecode64() throws Exception
   {
      ObjectName name = new ObjectName("jboss.security:service=JaasSecurityDomain,domain=encode-decode");
      byte[] secret = "secret".getBytes();
      Object[] args = {secret};
      String[] sig = {secret.getClass().getName()};
      String encode = (String) super.invoke(name, "encode64", args, sig);
      Object[] args2 = {encode};
      String[] sig2 = {"java.lang.String"};
      byte[] decode = (byte[]) super.invoke(name, "decode64", args2, sig2);
      assertTrue("secret == decode", Arrays.equals(secret, decode));
   }

   /**
    * Setup the test suite.
    */
   public static Test suite() throws Exception
   {
      TestSuite suite = new TestSuite();
      suite.addTest(new TestSuite(JaasSecurityDomainUnitTestCase.class));

      // Create an initializer for the test suite
      TestSetup wrapper = new JBossTestSetup(suite)
      {
         protected void setUp() throws Exception
         {
            super.setUp();
            // Create a tmp password file for testTmpFilePassword
            File password = new File(System.getProperty("java.io.tmpdir"), "tmp.password");
            FileWriter writer = new FileWriter(password);
            writer.write("password1");
            writer.close();

            // Create the opaque password file for testFilePassword
            String[] args2 = {
               "12345678", // salt
               "17", // count
               "password2", // password
               System.getProperty("java.io.tmpdir")+ "/tst.password" // password-file
            };
            FilePassword.main(args2);
            getLog().info("Created password file: "+args2[2]);

            String url = getResourceURL("security/jaassecdomain-tests-service.xml");
            deploy(url);
            flushAuthCache("unit-tests");
         }
         protected void tearDown() throws Exception
         {
            String url = getResourceURL("security/jaassecdomain-tests-service.xml");
            undeploy(url);
            super.tearDown();
         
         }
      };
      return wrapper;
   }

}
