package org.jboss.test.securitymgr.ejb;

import java.security.Principal;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.security.auth.Subject;

import org.apache.log4j.Category;

import org.jboss.security.SecurityAssociation;
import org.jboss.security.SimplePrincipal;

/** A session bean that attempts things that should not be allowed
when running JBoss with a security manager.
 
@author Scott.Stark@jboss.org
@version $Revision: 1.1.4.1 $
 */
public class BadBean implements SessionBean
{
   static final Category log = Category.getInstance(BadBean.class);

   public void ejbCreate()
   {
   }
   public void ejbActivate()
   {
   }
   public void ejbPassivate()
   {
   }
   public void ejbRemove()
   {
   }

   public void setSessionContext(SessionContext context)
   {
   }

   /** Creates a new instance of BadBean */
   public BadBean()
   {
   }
   
   public void accessSystemProperties()
   {
      System.getProperty("java.home");
      System.setProperty("java.home","tjo");
   }
   
   public Principal getPrincipal()
   {
      return SecurityAssociation.getPrincipal();
   }
   public Object getCredential()
   {
      return SecurityAssociation.getCredential();
   }
   public void setPrincipal(Principal user)
   {
      SecurityAssociation.setPrincipal(user);
   }
   public void setCredential(char[] password)
   {
      SecurityAssociation.setCredential(password);
   }
   public void getSubject()
   {
      // This should be allowed
      Subject s = SecurityAssociation.getSubject();
   }
   public void getSubjectCredentials()
   {
      // This should be allowed
      Subject s = SecurityAssociation.getSubject();
      // This should fail
      s.getPrivateCredentials();
   }
   public void setSubject()
   {
      Subject s = new Subject();
      SecurityAssociation.setSubject(s);
   }
   public void popRunAsRole()
   {
      SecurityAssociation.popRunAsRole();
   }
   public void pushRunAsRole()
   {
      SimplePrincipal runAs = new SimplePrincipal("SuperUser");
      SecurityAssociation.pushRunAsRole(runAs);
   }

}
