/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */

package org.jboss.test.testbeancluster.interfaces;

import java.rmi.RemoteException;
import javax.ejb.EJBObject;

/**
 * A stateless session interface for clustering testing
 *
 * @author  <a href="mailto:sacha.labourey@cogito-info.ch">Sacha Labourey</a>.
 * @version $Revision: 1.1.4.2 $
 */
public interface StatelessSession extends EJBObject
{
   public void callBusinessMethodA()
      throws RemoteException;
   public String callBusinessMethodB(String jndiURL)
      throws RemoteException;

   public void resetNumberOfCalls()
      throws RemoteException;

   public void makeCountedCall()
      throws RemoteException;

   public long getCallCount()
      throws RemoteException;
}
