/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.test.tm.ejb;

import javax.ejb.EJBException;
import javax.naming.InitialContext;
import javax.transaction.Status;
import javax.transaction.TransactionManager;

import org.jboss.test.util.ejb.SessionSupport;

public class TxTimeoutBean extends SessionSupport
{
   public void ejbCreate()
   {
   }
   
   /**
    * The harness should have set the default timeout to 10 secs
    */
   public void testDefaultTimeout()
   {
      try
      {
         Thread.sleep(12000);
      }
      catch (Exception ignored)
      {
         log.debug("Ignored", ignored);
      }
      if (getTxStatus() != Status.STATUS_MARKED_ROLLBACK)
         throw new EJBException("Should be marked rolled back " + getTxStatus());
   }

   /**
    * This method's timeout should be 5 secs
    */
   public void testOverriddenTimeoutExpires()
   {
      try
      {
         Thread.sleep(7000);
      }
      catch (Exception ignored)
      {
         log.debug("Ignored", ignored);
      }
      if (getTxStatus() != Status.STATUS_MARKED_ROLLBACK)
         throw new EJBException("Should be marked rolled back " + getTxStatus());
   }

   /**
    * This method's timeout should be 20 secs
    */
   public void testOverriddenTimeoutDoesNotExpire()
   {
      try
      {
         Thread.sleep(12000);
      }
      catch (Exception e)
      {
         throw new EJBException(e);
      }
      if (getTxStatus() != Status.STATUS_ACTIVE)
         throw new EJBException("Should be active " + getTxStatus());
   }
   
   private int getTxStatus()
   {
      try
      {
         InitialContext ctx = new InitialContext();
         TransactionManager tm = (TransactionManager) ctx.lookup("java:/TransactionManager");
         return tm.getStatus();
      }
      catch (Exception e)
      {
         throw new EJBException(e);
      }
   }
}
