package org.jboss.test.util;

import java.net.URL;
import java.io.File;

/** A utility class that moves a class file to a .bak file to effectively
 * remove it from the classpath using #move(String) and restores it using
 * #restore(File).
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.1 $
 */
public class ClassMover
{
   public static File move(String className)
      throws ClassNotFoundException
   {
      File classFileBak = null;
      String resName = className.replace('.', '/');
      URL classRes = ClassMover.class.getResource("/" + resName + ".class");
      if (classRes != null)
      {
         System.out.println("Found "+className+" impl at: " + classRes);
         File classFile = new File(classRes.getFile());
         classFileBak = new File(classFile.getAbsolutePath() + ".bak");
         classFileBak.delete();
         boolean moved = classFile.renameTo(classFileBak);
         System.out.println("Moved to .bak: " + moved);
      }
      else
      {
         throw new ClassNotFoundException("No class file found: "+className);
      }
      return classFileBak;
   }

   public static void restore(File classFileBak)
   {
      if( classFileBak.exists() )
      {
         String name = classFileBak.getAbsolutePath();
         String origName = name.substring(0, name.length() - 4);
         File classFile = new File(origName);
         boolean restored = classFileBak.renameTo(classFile);
         System.out.println("Restored from .bak: " + restored);
      }
   }
}
