package org.jboss.test.util.web;

import java.net.URL;
import java.net.HttpURLConnection;
import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.jboss.logging.Logger;

/** Utilities for client http requests
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.3 $
 */
public class HttpUtils
{
   private static Logger log = Logger.getLogger(HttpUtils.class);
   private static String baseURL = "http://jduke:theduke@localhost:" + Integer.getInteger("web.port", 8080) + "/"; 
   private static String baseURLNoAuth = "http://localhost:" + Integer.getInteger("web.port", 8080) + "/"; 

   public static String getBaseURL()
   {
      return baseURL;
   }
   public static String getBaseURLNoAuth()
   {
      return baseURLNoAuth;
   }

   /** Perform a get on the indicated URL and assert an HTTP_OK response code
    * 
    * @param url
    * @return The commons HttpClient used to perform the get
    * @throws Exception on any failure
    */ 
   public static HttpMethodBase accessURL(URL url) throws Exception
   {
      return accessURL(url, "JBossTest Servlets", HttpURLConnection.HTTP_OK);
   }
   /** Perform a get on the indicated URL and assert that the response code
    * matches the expectedHttpCode argument.
    * 
    * @param url
    * @param expectedHttpCode the http response code expected
    * @return The commons HttpClient used to perform the get
    * @throws Exception on any failure
    */ 
   public static HttpMethodBase accessURL(URL url, String realm,
      int expectedHttpCode)
      throws Exception
   {
      HttpClient httpConn = new HttpClient();
      GetMethod request = new GetMethod(url.toString());
      try
      {
         log.debug("Connecting to: "+url);
         String userInfo = url.getUserInfo();
         if( userInfo != null )
         {
            UsernamePasswordCredentials auth = new UsernamePasswordCredentials(userInfo);
            httpConn.getState().setCredentials(realm, url.getHost(), auth);
         }
         log.debug("RequestURI: "+request.getURI());
         int responseCode = httpConn.executeMethod(request);
         String response = request.getStatusText();
         log.debug("responseCode="+responseCode+", response="+response);
         String content = request.getResponseBodyAsString();
         log.debug(content);
         // Validate that we are seeing the requested response code
         if( responseCode != expectedHttpCode )
         {
            throw new IOException("Expected reply code:"+expectedHttpCode
               +", actual="+responseCode);
         }
      }
      catch(IOException e)
      {
         throw e;
      }
      return request;
   }

}
