#!/bin/sh
##
##  Sets up the basic environment for Jython and then starts it.
##
##  @author Jason Dillon <jason@planet57.com>
##

# $Id: jython.sh,v 1.2 2003/12/17 08:47:22 cazzius Exp $

PROGNAME=`basename $0`
DIRNAME=`dirname $0`

# Setup Jython options
PYTHON_HOME=`cd $DIRNAME/.. && pwd`
PYTHON_PATH="$PYTHON_HOME"
PYTHON_CACHE_DIR=PATH="$PYTHON_HOME"
PYTHON_VERBOSE="warning"

# Setup Java
if [ -z "$JAVA_HOME" ]; then
    JAVA="java"
else
    JAVA="$JAVA_HOME/bin/java"
fi
JAVA_OPTS="$JAVA_OPTS \
           -Dinstall.root=$PYTHON_HOME \
           -Dpython.home=$PYTHON_HOME \
           -Dpython.verbose=$PYTHON_VERBOSE \
           -Dpython.path=$PYTHON_PATH \
           -Dpython.cachedir=$PYTHON_CACHE_DIR \
           -Dpython.security.respectJavaAccessibility=true"

# TODO: For better support, translate path for Cygwin
#       (should find a way to include common.shlib)
CLASSPATH="$PYTHON_HOME/jython.jar:$CLASSPATH"

export PYTHON_HOME CLASSPATH

exec $JAVA $JAVA_OPTS -classpath $CLASSPATH org.python.util.jython "$@"
