/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.web.tomcat.security;

import java.security.Principal;
import java.util.List;
import javax.security.auth.Subject;

import org.apache.catalina.Realm;
import org.apache.catalina.realm.GenericPrincipal;

/**
 * An implementation of the catalina GenericPrincipal to allow caching of
 * security manager invocation results.
 * 
 * @author remm@jboss.org
 * @author Scott.Stark@jboss.org
 * @version $Revision: 1.1.2.4 $
 */
class JBossGenericPrincipal
   extends GenericPrincipal
{
   /** The authenticated user name as a Principal */
   private Principal authPrincipal = null;
   /** The caller principal name mapping if any */
   private Principal callerPrincipal = null;
   /** The authenticated user credentials */
   private Object credentials = null;
   /** The authenticated user Subject */
   private Subject subject = null;

   JBossGenericPrincipal(Realm realm, Subject subject,
      Principal authPrincipal, Principal callerPrincipal,
      Object credentials, List roles)
   {
      super(realm, callerPrincipal.getName(), null, roles);
      this.credentials = credentials;
      this.authPrincipal = authPrincipal;
      this.callerPrincipal = callerPrincipal;
      this.subject = subject;
   }

   Principal getAuthPrincipal()
   {
      return this.authPrincipal;
   }
   /**
    * Gets the value of principal
    * 
    * @return the value of principal
    */
   Principal getCallerPrincipal()
   {
      return this.callerPrincipal;
   }

   /**
    * Gets the value of credentials
    * 
    * @return the value of credentials
    */
   Object getCredentials()
   {
      return this.credentials;
   }

   Subject getSubject()
   {
      return subject;
   }

}
