/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor;

import javax.management.Notification;
import javax.management.ObjectName;
import java.util.Map;
import java.util.HashMap;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 1.1.2.1 $
 *
 **/
public class ThresholdNotification
        extends JBossMonitorNotification
{
   public static final String TRIGGERED_ATTRIBUTE_VALUE="TRIGGERED_ATTRIBUTE_VALUE";
   public static final String THRESHOLD = "THRESHOLD";

   private final Number value;
   private final Number threshold;

   public ThresholdNotification(String monitorName, ObjectName monitorObjectName, ObjectName observedObject,
                                String attribute, Number value, Number threshold, long sequenceNumber)
   {
      super(monitorName, monitorObjectName, observedObject, attribute, sequenceNumber);
      this.value = value;
      this.threshold = threshold;
   }

   public Number getValue()
   {
      return value;
   }

   public Number getThreshold()
   {
      return threshold;
   }

   /**
    * Return a substitution map that can be used by org.jboss.util.Strings.subst
    * to create a printable alert message.
    *
    * @return
    */
   public Map substitutionMap()
   {
      Map map = super.substitutionMap();
      map.put(TRIGGERED_ATTRIBUTE_VALUE, value);
      map.put(THRESHOLD, threshold);
      return map;
   }
}
