/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.monitor.alerts;

import javax.management.Notification;
import org.jboss.util.Strings;
import org.jboss.monitor.JBossMonitorNotification;

import java.util.Map;

/**
 * Comment
 *
 * @author <a href="mailto:bill@jboss.org">Bill Burke</a>
 * @version $Revision: 1.1.2.2 $
 *
 **/
public class ConsoleAlertListener extends JBossAlertListener implements ConsoleAlertListenerMBean
{
   protected String messageTemplate;

   public void handleNotification(Notification notification,
                                  Object handback)
   {
      if (!(notification instanceof JBossMonitorNotification)) return;
      Map substitutions = ((JBossMonitorNotification)notification).substitutionMap();
      String message = Strings.subst(messageTemplate, substitutions, "%(", ")");
      System.out.println(message);
   }

   public String getMessageTemplate()
   {
      return messageTemplate;
   }

   public void setMessageTemplate(String messageTemplate)
   {
      this.messageTemplate = messageTemplate;
   }

}
