/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.varia.stats;

import java.io.Serializable;

/**
 * todo: this should be devided into StatisticalItemMerger and StatisticalItem
 *
 * @author <a href="mailto:alex@jboss.org">Alexey Loubyansky</a>
 * @version <tt>$Revision: 1.1.2.4 $</tt>
 */
public interface StatisticalItem
   extends Serializable
{
   public String getName();

   public String getValue();

   public int getMinCountPerTx();

   public int getMaxCountPerTx();

   public int getCount();

   public void add(StatisticalItem item);

   public void merge(StatisticalItem item);

   public void mergeNull();

   public int getMergedItemsTotal();
}
