/*
 * Decompiled with CFR 0.152.
 */
package jcckit.plot;

import java.util.Hashtable;
import java.util.Properties;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Polygon;
import jcckit.graphic.Rectangle;
import jcckit.graphic.Text;
import jcckit.graphic.TextAttributes;
import jcckit.plot.SymbolFactory;
import jcckit.util.ConfigData;
import jcckit.util.ConfigParameters;
import jcckit.util.ConfigParametersBasedConfigData;
import jcckit.util.Factory;
import jcckit.util.PropertiesBasedConfigData;

public class Legend {
    public static final String UPPER_RIGHT_CORNER_KEY = "upperRightCorner";
    public static final String BOX_WIDTH_KEY = "boxWidth";
    public static final String BOX_HEIGHT_KEY = "boxHeight";
    public static final String BOX_ATTRIBUTES_KEY = "boxAttributes";
    public static final String TITLE_KEY = "title";
    public static final String TITLE_DISTANCE_KEY = "titleDistance";
    public static final String TITLE_ATTRIBUTES_KEY = "titleAttributes";
    public static final String LEFT_DISTANCE_KEY = "leftDistance";
    public static final String BOTTOM_DISTANCE_KEY = "bottomDistance";
    public static final String TOP_DISTANCE_KEY = "topDistance";
    public static final String LINE_LENGTH_KEY = "lineLength";
    public static final String SYMBOL_SIZE_KEY = "symbolSize";
    public static final String CURVE_TITLE_DISTANCE_KEY = "curveTitleDistance";
    public static final String CURVE_TITLE_ATTRIBUTES_KEY = "curveTitleAttributes";
    private final GraphicalComposite _box;
    private final TextAttributes _curveTitleAttributes;
    private final double _xSymbol;
    private final double _xText;
    private final double _yBase;
    private final double _yLastRow;
    private final double _length;
    private final double _size;
    static /* synthetic */ Class class$jcckit$graphic$ShapeAttributes;
    static /* synthetic */ Class class$jcckit$graphic$BasicGraphicAttributes;

    public Legend(ConfigParameters config) {
        config = this.mergeWithDefaultConfig(config);
        GraphPoint corner = new GraphPoint(config.getDoubleArray(UPPER_RIGHT_CORNER_KEY, new double[]{0.94, 0.54}));
        double width = config.getDouble(BOX_WIDTH_KEY, 0.2);
        double height = config.getDouble(BOX_HEIGHT_KEY, 0.1);
        this._curveTitleAttributes = (TextAttributes)Factory.create(config.getNode(CURVE_TITLE_ATTRIBUTES_KEY));
        this._xSymbol = corner.getX() - width + config.getDouble(LEFT_DISTANCE_KEY, 0.01);
        this._yBase = corner.getY() - config.getDouble(TOP_DISTANCE_KEY, 0.04);
        this._yLastRow = corner.getY() - height + config.getDouble(BOTTOM_DISTANCE_KEY, 0.02);
        this._length = config.getDouble(LINE_LENGTH_KEY, 0.035);
        this._size = config.getDouble(SYMBOL_SIZE_KEY, 0.01);
        this._xText = this._xSymbol + this._length + config.getDouble(CURVE_TITLE_DISTANCE_KEY, 0.005);
        this._box = new GraphicalComposite(null);
        double xCenter = corner.getX() - width / 2.0;
        this._box.addElement(new Rectangle(new GraphPoint(xCenter, corner.getY() - height / 2.0), width, height, (GraphicAttributes)Factory.create(config.getNode(BOX_ATTRIBUTES_KEY))));
        this._box.addElement(new Text(new GraphPoint(xCenter, corner.getY() - config.getDouble(TITLE_DISTANCE_KEY, 0.005)), config.get(TITLE_KEY, "Legend"), (TextAttributes)Factory.create(config.getNode(TITLE_ATTRIBUTES_KEY))));
    }

    private ConfigParameters mergeWithDefaultConfig(ConfigParameters config) {
        Properties p = new Properties();
        ((Hashtable)p).put("boxAttributes/className", (class$jcckit$graphic$ShapeAttributes == null ? (class$jcckit$graphic$ShapeAttributes = Legend.class$("jcckit.graphic.ShapeAttributes")) : class$jcckit$graphic$ShapeAttributes).getName());
        ((Hashtable)p).put("boxAttributes/fillColor", "0xffffff");
        ((Hashtable)p).put("boxAttributes/lineColor", "0");
        ((Hashtable)p).put("titleAttributes/className", (class$jcckit$graphic$BasicGraphicAttributes == null ? (class$jcckit$graphic$BasicGraphicAttributes = Legend.class$("jcckit.graphic.BasicGraphicAttributes")) : class$jcckit$graphic$BasicGraphicAttributes).getName());
        ((Hashtable)p).put("titleAttributes/horizontalAnchor", "center");
        ((Hashtable)p).put("titleAttributes/verticalAnchor", "top");
        ((Hashtable)p).put("curveTitleAttributes/className", (class$jcckit$graphic$BasicGraphicAttributes == null ? (class$jcckit$graphic$BasicGraphicAttributes = Legend.class$("jcckit.graphic.BasicGraphicAttributes")) : class$jcckit$graphic$BasicGraphicAttributes).getName());
        ConfigData cd = new PropertiesBasedConfigData(p);
        cd = new ConfigParametersBasedConfigData(config, new ConfigParameters(cd));
        return new ConfigParameters(cd);
    }

    public GraphicalElement getBox() {
        return this._box;
    }

    public GraphicalElement createSymbol(int curveIndex, int numberOfCurves, SymbolFactory factory, boolean withLine, GraphicAttributes lineAttributes) {
        GraphicalComposite result = new GraphicalComposite(null);
        double y = this.calculateBaseLine(curveIndex, numberOfCurves);
        if (withLine) {
            Polygon line = new Polygon(lineAttributes, false);
            line.addPoint(new GraphPoint(this._xSymbol, y));
            line.addPoint(new GraphPoint(this._xSymbol + this._length, y));
            result.addElement(line);
        }
        if (factory != null) {
            result.addElement(factory.createLegendSymbol(new GraphPoint(this._xSymbol + this._length / 2.0, y), this._size));
        }
        return result;
    }

    private double calculateBaseLine(int curveIndex, int numberOfCurves) {
        if (numberOfCurves > 1) {
            return this._yBase + (this._yLastRow - this._yBase) / (double)(numberOfCurves - 1) * (double)curveIndex;
        }
        return 0.5 * (this._yBase + this._yLastRow);
    }

    public GraphicalElement createCurveTitle(int curveIndex, int numberOfCurves, String title) {
        return new Text(new GraphPoint(this._xText, this.calculateBaseLine(curveIndex, numberOfCurves)), title, this._curveTitleAttributes);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

