/*
 * Decompiled with CFR 0.152.
 */
package jcckit.util;

import java.awt.Color;
import java.util.StringTokenizer;
import jcckit.util.ConfigData;

public class ConfigParameters {
    private final ConfigData _configData;

    public ConfigParameters(ConfigData configData) {
        this._configData = configData;
    }

    public String getFullKey(String key) {
        return this._configData.getFullKey(key);
    }

    public String get(String key) {
        String result = this._configData.get(key);
        if (result == null) {
            throw new IllegalArgumentException(this.getFullKey(key));
        }
        return result;
    }

    public String get(String key, String defaultValue) {
        String result = this._configData.get(key);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public boolean getBoolean(String key) {
        return this.parseBoolean(this.get(key), key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this._configData.get(key);
        return value == null ? defaultValue : this.parseBoolean(value, key);
    }

    private boolean parseBoolean(String value, String key) {
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw this.createNumberFormatException("boolean", value, key);
    }

    private NumberFormatException createNumberFormatException(String text, String value, String key) {
        return new NumberFormatException("Not a " + text + ": " + this.getFullKey(key) + " = " + value);
    }

    public int getInt(String key) {
        return this.parseInt(this.get(key), key);
    }

    public int getInt(String key, int defaultValue) {
        String value = this._configData.get(key);
        return value == null ? defaultValue : this.parseInt(value, key);
    }

    private int parseInt(String value, String key) {
        try {
            return Integer.decode(value);
        }
        catch (NumberFormatException e) {
            throw this.createNumberFormatException("number", value, key);
        }
    }

    public double getDouble(String key) {
        return this.parseDouble(this.get(key), key);
    }

    public double getDouble(String key, double defaultValue) {
        String value = this._configData.get(key);
        return value == null ? defaultValue : this.parseDouble(value, key);
    }

    private double parseDouble(String value, String key) {
        try {
            return new Double(value);
        }
        catch (NumberFormatException e) {
            throw this.createNumberFormatException("number", value, key);
        }
    }

    public double[] getDoubleArray(String key) {
        return this.parseDoubleArray(this.get(key), key);
    }

    public double[] getDoubleArray(String key, double[] defaultValue) {
        String value = this._configData.get(key);
        return value == null ? defaultValue : this.parseDoubleArray(value, key);
    }

    private double[] parseDoubleArray(String value, String key) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value);
            double[] result = new double[tokenizer.countTokens()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new Double(tokenizer.nextToken());
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw this.createNumberFormatException("sequence of numbers", value, key);
        }
    }

    public Color getColor(String key) {
        return this.parseColor(this.get(key), key);
    }

    public Color getColor(String key, Color defaultValue) {
        String value = this._configData.get(key);
        return value == null ? defaultValue : this.parseColor(value, key);
    }

    private Color parseColor(String value, String key) {
        try {
            return value.length() == 0 ? null : Color.decode(value);
        }
        catch (NumberFormatException e) {
            throw this.createNumberFormatException("number", value, key);
        }
    }

    public ConfigParameters getNode(String key) {
        return new ConfigParameters(this._configData.getNode(key));
    }
}

