/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.PortView;

public class GraphContext
implements CellMapper {
    protected JGraph graph;
    protected transient GraphLayoutCache graphLayoutCache;
    protected Object[] cells;
    protected Set cellSet;
    protected int cellCount;
    protected Map views = new Hashtable();

    public GraphContext(JGraph jGraph, Object[] objectArray) {
        GraphModel graphModel = jGraph.getModel();
        this.cellSet = DefaultGraphModel.getDescendants(graphModel, objectArray);
        this.graphLayoutCache = jGraph.getGraphLayoutCache();
        this.graph = jGraph;
        this.cells = objectArray;
        Iterator iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            if (graphModel.isPort(iterator.next())) continue;
            ++this.cellCount;
        }
    }

    public boolean isEmpty() {
        return this.cells == null || this.cells.length == 0;
    }

    public int getDescendantCount() {
        return this.cellCount;
    }

    public JGraph getGraph() {
        return this.graph;
    }

    public Object[] getCells() {
        return this.cells;
    }

    public boolean contains(Object object) {
        return this.cellSet.contains(object);
    }

    public CellView[] createTemporaryCellViews() {
        CellView[] cellViewArray = new CellView[this.cells.length];
        int n = 0;
        while (n < this.cells.length) {
            cellViewArray[n] = this.getMapping(this.cells[n], true);
            ++n;
        }
        return cellViewArray;
    }

    public CellView[] createTemporaryPortViews() {
        Object object;
        GraphModel graphModel = this.graph.getModel();
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Iterator iterator = this.cellSet.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!graphModel.isPort(object) || !this.graph.getGraphLayoutCache().isVisible(object)) continue;
            arrayList.add(this.getMapping(object, true));
        }
        object = new PortView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public CellView[] createTemporaryContextViews() {
        return this.createTemporaryContextViews(this.cellSet);
    }

    public CellView[] createTemporaryContextViews(Set set) {
        Object object;
        Object[] objectArray = set.toArray();
        Set set2 = DefaultGraphModel.getEdges(this.graph.getModel(), objectArray);
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Iterator iterator = set2.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (set.contains(object) || !this.graphLayoutCache.isVisible(object) || this.graphLayoutCache.getMapping(object, false) == null) continue;
            arrayList.add(this.createMapping(object));
        }
        object = new CellView[arrayList.size()];
        arrayList.toArray((T[])object);
        return object;
    }

    public CellView getMapping(Object object, boolean bl) {
        if (object != null) {
            CellView cellView = (CellView)this.views.get(object);
            if (cellView != null) {
                return cellView;
            }
            if (this.contains(object)) {
                return this.createMapping(object);
            }
            return this.graphLayoutCache.getMapping(object, false);
        }
        return null;
    }

    public CellView createMapping(Object object) {
        CellView cellView = this.graphLayoutCache.getMapping(object, false);
        CellView cellView2 = this.graphLayoutCache.getFactory().createView(this.getGraph(), this, object);
        if (cellView != null) {
            cellView2.setAttributes((AttributeMap)cellView.getAllAttributes().clone());
            cellView2.refresh(false);
        }
        return cellView2;
    }

    public ConnectionSet disconnect(CellView[] cellViewArray) {
        ConnectionSet connectionSet = new ConnectionSet();
        int n = 0;
        while (n < cellViewArray.length) {
            if (cellViewArray[n] instanceof EdgeView) {
                EdgeView edgeView = (EdgeView)cellViewArray[n];
                CellView cellView = edgeView.getSource();
                if (GraphConstants.isDisconnectable(edgeView.getAllAttributes())) {
                    if (cellView != null && GraphConstants.isDisconnectable(cellView.getParentView().getAllAttributes()) && !this.contains(cellView.getCell())) {
                        edgeView.setSource(null);
                        connectionSet.disconnect(edgeView.getCell(), true);
                    }
                    if ((cellView = edgeView.getTarget()) != null && GraphConstants.isDisconnectable(cellView.getParentView().getAllAttributes()) && !this.contains(cellView.getCell())) {
                        edgeView.setTarget(null);
                        connectionSet.disconnect(edgeView.getCell(), false);
                    }
                }
            }
            ++n;
        }
        return connectionSet;
    }

    public void putMapping(Object object, CellView cellView) {
        this.views.put(object, cellView);
    }
}

