/*
 * @(#)HelloWorld.java 3.3 23-APR-04
 * 
 * Copyright (c) 2001-2004, Gaudenz Alder All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer. - Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution. - Neither the name of JGraph nor
 * the names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *  
 */
package org.jgraph.example;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.Hashtable;
import java.util.Map;

import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;

public class HelloWorld {

  public static void main(String[] args) {

    // Construct Model and Graph
    //
    GraphModel model = new DefaultGraphModel();
    JGraph graph = new JGraph(model);
    graph.setSelectNewCells(true);

    // Create Nested Map (from Cells to Attributes)
    //
    Map attributes = new Hashtable();

    // Create Hello Vertex
    //
    DefaultGraphCell hello = new DefaultGraphCell("Hello");
    
    // Create Hello Vertex Attributes
    //
    AttributeMap helloAttrib = model.createAttributes();
    attributes.put(hello, helloAttrib);
    // Set bounds
    Rectangle2D helloBounds = helloAttrib.createRect(20, 20, 40, 20);
    GraphConstants.setBounds(helloAttrib, helloBounds);
    // Set black border
    GraphConstants.setBorderColor(helloAttrib, Color.black);

    // Add a Port
    //
    DefaultPort hp = new DefaultPort();
    hello.add(hp);

    // Create World Vertex
    //
    DefaultGraphCell world = new DefaultGraphCell("World");

    // Create World Vertex Attributes
    //
    AttributeMap worldAttrib = model.createAttributes();
    attributes.put(world, worldAttrib);
    // Set bounds
    Rectangle2D worldBounds = worldAttrib.createRect(140, 140, 40, 20);
    GraphConstants.setBounds(worldAttrib , worldBounds);
    // Set fill color
    GraphConstants.setBackground(worldAttrib, Color.orange);
    GraphConstants.setOpaque(worldAttrib, true);
    // Set raised border
    GraphConstants.setBorder(worldAttrib, 
           BorderFactory.createRaisedBevelBorder());

    // Add a Port
    //
    DefaultPort wp = new DefaultPort();
    world.add(wp);

    // Create Edge
    //
    DefaultEdge edge = new DefaultEdge();
    
    // Create Edge Attributes
    //
    AttributeMap edgeAttrib = model.createAttributes();
    attributes.put(edge, edgeAttrib);
    // Set Arrow
    int arrow = GraphConstants.ARROW_CLASSIC;
    GraphConstants.setLineEnd(edgeAttrib , arrow);
    GraphConstants.setEndFill(edgeAttrib, true);

    // Connect Edge
    //
    ConnectionSet cs = new ConnectionSet(edge, hp, wp);
    Object[] cells = new Object[]{edge, hello, world};

    // Insert into Model
    //
    model.insert(cells, attributes, cs, null, null);

    // Show in Frame
    //
    JFrame frame = new JFrame();
    frame.getContentPane().add(new JScrollPane(graph));
    //frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
    frame.pack();
    frame.setVisible(true);
  }

}