/*
 * @(#)MyPortView.java 3.3 23-APR-04
 * 
 * Copyright (c) 2001-2004, Gaudenz Alder All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer. - Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution. - Neither the name of JGraph nor
 * the names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *  
 */
package org.jgraph.example;

import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

import org.jgraph.JGraph;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.Port;
import org.jgraph.graph.PortRenderer;
import org.jgraph.graph.PortView;

public class MyPortView extends PortView {

	public static void main(String[] args) {
		URL portUrl = Main.class.getClassLoader().getResource("org/jgraph/example/resources/port.gif");
		if (portUrl != null)
			portIcon = new ImageIcon(portUrl);
		JFrame frame = new JFrame("PortView");
		JGraph graph = new JGraph() {
			/**
			 * Constructs a PortView view for the specified object.
			 */
			protected PortView createPortView(JGraph graph, CellMapper cm, Port p) {
				return new MyPortView(p, graph, cm);
			}
		};
		graph.setPortsVisible(true);
		frame.getContentPane().add(new JScrollPane(graph));
		frame.pack();
		//frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setVisible(true);
	}

	protected static ImageIcon portIcon = null;

	protected static MyPortRenderer renderer = new MyPortRenderer();

	public MyPortView(Object cell, JGraph graph, CellMapper cm) {
		super(cell, graph, cm);
	}

	/** 
	* Returns the bounds for the port view. 
	*/
	public Rectangle2D getBounds() {
		if (portIcon != null) {
			Rectangle2D bounds = (Rectangle2D) getLocation(null).clone();
			int width = portIcon.getIconWidth();
			int height = portIcon.getIconHeight();
			bounds.setFrame(bounds.getX() - width / 2,
							bounds.getY() - height / 2,
							width,
							height);
			return bounds;
		}
		return super.getBounds();
	}

	public CellViewRenderer getRenderer() {
		return renderer;
	}

	public static class MyPortRenderer extends PortRenderer {

		public void paint(Graphics g) {
			g.setColor(graph.getBackground());
			//g.setXORMode(graph.getBackground());
			/*if (preview) {
				Dimension d = getSize();
				g.setColor(Color.red);
				g.drawRect(1, 1, d.width - 3, d.height - 3);
				g.drawRect(2, 2, d.width - 5, d.height - 5);
			} else*/
				portIcon.paintIcon(graph, g, 0, 0);
		}

	}

}
