/*
 * @(#)Main.java 3.3 23-APR-04
 * 
 * Copyright (c) 2001-2004, Gaudenz Alder All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer. - Redistributions in
 * binary form must reproduce the above copyright notice, this list of
 * conditions and the following disclaimer in the documentation and/or other
 * materials provided with the distribution. - Neither the name of JGraph nor
 * the names of its contributors may be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *  
 */
package org.jgraph.example;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;

public class Main {

	// Construct Frame
	static JFrame f = new JFrame("JGraph Examples");

	// Main Method
	public static void main(String[] args) {
		// Set Close Operation to Exit
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		// Get Content Pane
		Container p = f.getContentPane();
		// Set Layout
		p.setLayout(new GridLayout(3,2));
		// Add Buttons
		p.add(createButton(org.jgraph.example.EditorGraph.class, args));
		p.add(createButton(org.jgraph.example.GraphEd.class, args));
		p.add(createButton(org.jgraph.example.GraphEdMV.class, args));
		p.add(createButton(org.jgraph.example.GraphTreeModel.class, args));
		p.add(createButton(org.jgraph.example.MyPortView.class, args));
		p.add(createButton(org.jgraph.example.HelloWorld.class, args));
		// Set Default Size
		f.pack();
		// Show Frame
		f.show();
	}

	public static JButton createButton(final Class aClass, final String[] args) {
		JButton b = new JButton(aClass.getName().substring(aClass.getPackage().getName().length()+1));
		b.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				run(aClass, args);
			}
		});
		return b;
	}

	public static void run(Class aClass, String[] args) {
		try {
			aClass.getDeclaredMethod("main", new Class[]{String[].class}).
				invoke(null, new Object[]{args});
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
