/*
 * Decompiled with CFR 0.152.
 */
package jm.audio;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StreamTokenizer;
import java.util.Enumeration;
import java.util.Stack;
import jm.JMC;
import jm.audio.AOException;
import jm.audio.Instrument;
import jm.audio.io.SampleOut;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public final class Audio
implements JMC {
    private static boolean JPF = false;
    private static int channels;
    private static int sampleRate;

    public static void processScore(Score score, Instrument[] instrumentArray, String string) {
        Stack<Instrument> stack = new Stack<Instrument>();
        stack.push(instrumentArray[0]);
        for (int i = 0; i < instrumentArray.length; ++i) {
            if (instrumentArray[i].getInitialised()) continue;
            try {
                if (instrumentArray[i].getInitialised()) continue;
                instrumentArray[i].createChain();
                instrumentArray[i].setInitialised(true);
                continue;
            }
            catch (AOException aOException) {
                aOException.printStackTrace();
            }
        }
        Enumeration enumeration = score.getPartList().elements();
        double d = 60.0 / score.getTempo();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            double d2 = d;
            if (part.getTempo() > 0.0) {
                d2 = 60.0 / part.getTempo();
            }
            if (part.getInstrument() != -1) {
                try {
                    stack.push(instrumentArray[part.getInstrument()]);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    System.out.println("jMusic Audio warning: Can't find the instrument number " + part.getInstrument() + " that you have specified for " + "the part named " + part.getTitle() + ".");
                }
            }
            System.out.println("Part " + n++ + " '" + part.getTitle() + "'. ");
            Enumeration enumeration2 = part.getPhraseList().elements();
            int n2 = 0;
            while (enumeration2.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration2.nextElement();
                double d3 = d2;
                if (phrase.getTempo() > 0.0) {
                    System.out.println("A: " + d3);
                    d3 = 60.0 / phrase.getTempo();
                    System.out.println("B: " + d3);
                }
                if (phrase.getInstrument() != -1) {
                    try {
                        stack.push(instrumentArray[phrase.getInstrument()]);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.out.println("jMusic Audio warning: Can't find the instrument number " + phrase.getInstrument() + " that you have specified for" + " the phrase named " + phrase.getTitle() + ".");
                    }
                }
                double d4 = d2 * phrase.getStartTime();
                double d5 = 0.0;
                Enumeration enumeration3 = phrase.getNoteList().elements();
                System.out.print("    Phrase " + n2++ + " '" + phrase.getTitle() + "'" + " starting at beat " + phrase.getStartTime() + ": ");
                int n3 = 0;
                while (enumeration3.hasMoreElements()) {
                    Note note = (Note)enumeration3.nextElement();
                    if (note.getFrequency() == -2.147483648E9) {
                        d5 += d3 * note.getRhythmValue();
                        continue;
                    }
                    if (++n3 % 10 == 0) {
                        System.out.print(n3);
                    } else {
                        System.out.print(".");
                    }
                    Note note2 = note.copy();
                    note2.setDuration(d3 * note.getDuration());
                    note2.setRhythmValue(d3 * note.getRhythmValue());
                    Instrument instrument = (Instrument)stack.peek();
                    instrument.setBlock(false);
                    instrument.setFinished(true);
                    instrument.renderNote(note2, d4 + d5);
                    instrument.setFinished(false);
                    instrument.iterateChain();
                    d5 += d3 * note.getRhythmValue();
                }
                System.out.println();
                if (phrase.getInstrument() == -1) continue;
                stack.pop();
            }
        }
    }

    public static void combine(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (bl2) {
            sampleRate = SampleOut.samprate;
            channels = SampleOut.numofchan;
            System.out.println("Sample rate: " + SampleOut.samprate + " Channels: " + SampleOut.numofchan);
            Audio.addEmUp(string2, string3, SampleOut.max);
            return;
        }
        int n = 1;
        float f = 0.0f;
        try {
            FileReader fileReader = new FileReader(string);
            StreamTokenizer streamTokenizer = new StreamTokenizer(fileReader);
            RandomAccessFile randomAccessFile = new RandomAccessFile(string2, "rw");
            double d = System.currentTimeMillis();
            block5: while (true) {
                try {
                    while (true) {
                        streamTokenizer.nextToken();
                        String string4 = streamTokenizer.sval;
                        if (string4 == null) break block5;
                        streamTokenizer.nextToken();
                        long l = (long)(streamTokenizer.nval * 4.0);
                        streamTokenizer.nextToken();
                        int n2 = (int)streamTokenizer.nval;
                        float f2 = Audio.getAudio(string4, l, n2, f, randomAccessFile);
                        if (f < f2) {
                            f = f2;
                            System.out.println("Max is smaller: " + f);
                        }
                        if (f2 < 0.0f && f < f2 * -1.0f) {
                            f = f2 * -1.0f;
                            System.out.println("MAX is bigger: " + f);
                        }
                        if (n % 10 == 0) {
                            System.out.print(n);
                        } else {
                            System.out.print(".");
                        }
                        ++n;
                        randomAccessFile.close();
                    }
                }
                catch (EOFException eOFException) {
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                break;
            }
            System.out.print("\n");
            double d2 = System.currentTimeMillis();
            System.out.println("Created tmp file in " + (d2 - d) / 1000.0 + " seconds");
            double d3 = System.currentTimeMillis();
            Audio.addEmUp(string2, string3, f);
            double d4 = System.currentTimeMillis();
            System.out.println("Mixed to a single file in " + (d4 - d3) / 1000.0 + " seconds");
            if (bl) {
                File file = new File(string);
                File file2 = new File(string2);
                file.delete();
                file2.delete();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static float getAudio(String string, long l, int n, float f, RandomAccessFile randomAccessFile) {
        FileInputStream fileInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        DataInputStream dataInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
            dataInputStream = new DataInputStream(bufferedInputStream);
            if (dataInputStream.readInt() != 779316836) {
                System.out.println("jMusic SampleIn warning: This file is NOT in the .au/.snd file format");
                return f;
            }
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            sampleRate = dataInputStream.readInt();
            channels = dataInputStream.readInt();
            fileInputStream.skip(n2 - 24);
            l *= (long)channels;
            n *= channels;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        block9: while (true) {
            try {
                while (true) {
                    randomAccessFile.seek(l);
                    float f2 = (float)dataInputStream.readShort() / 32767.0f;
                    try {
                        float f3 = randomAccessFile.readFloat();
                        randomAccessFile.seek(l);
                        l += 4L;
                        float f4 = f3 + f2;
                        if (f < f4) {
                            f = f4;
                            System.out.println("MAX small: " + f);
                        }
                        if (f4 < 0.0f && f < f4 * -1.0f) {
                            f = f4 * -1.0f;
                            System.out.println("MAX large: " + f);
                        }
                        randomAccessFile.writeFloat(f4);
                        continue block9;
                    }
                    catch (EOFException eOFException) {
                        if (f < f2) {
                            f = f2;
                        }
                        if (f2 < 0.0f && f < f2 * -1.0f) {
                            f = f2 * -1.0f;
                        }
                        randomAccessFile.writeFloat(f2);
                        l += 4L;
                        continue;
                    }
                    break;
                }
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                continue;
            }
            break;
        }
        try {
            dataInputStream.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return f;
    }

    public static void addEmUp(String string, String string2, float f) {
        System.out.println("MAX amplitude: " + f);
        System.out.println("Writing .au/.snd file '" + string2 + "' please wait...");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream, 4096);
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 4096);
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            int n = 28;
            int n2 = (int)file.length() / 2 + 16;
            int n3 = 3;
            dataOutputStream.writeInt(779316836);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeInt(sampleRate);
            dataOutputStream.writeInt(channels);
            dataOutputStream.writeInt(0);
            double d = System.currentTimeMillis();
            try {
                while (true) {
                    float f2;
                    float f3;
                    if ((f3 = (f2 = dataInputStream.readFloat()) / f) < -1.0f || f3 > 1.0f) {
                        System.out.println("Outgoing= " + f3 + "  SAMPLE: " + f2 + "  MAX: " + f + "  SampleOut.max: " + SampleOut.max);
                    }
                    dataOutputStream.writeShort((short)(f3 * 32767.0f));
                }
            }
            catch (EOFException eOFException) {
                double d2 = System.currentTimeMillis();
                System.out.println("Finished writing the audio file in " + (d2 - d) / 1000.0 + " seconds");
                dataOutputStream.flush();
                fileOutputStream.flush();
                bufferedOutputStream.flush();
                dataOutputStream.close();
                fileOutputStream.close();
                bufferedOutputStream.close();
                fileInputStream.close();
                bufferedInputStream.close();
                dataInputStream.close();
                file.delete();
                File file2 = new File(string);
                if (file2.exists()) {
                    file2.delete();
                }
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.out.println(iOException);
        }
    }
}

