/*
 * Decompiled with CFR 0.152.
 */
package jm.audio;

import jm.JMC;
import jm.audio.AOException;
import jm.audio.Instrument;
import jm.music.data.Note;

public abstract class AudioObject
implements JMC {
    protected AudioObject[] previous;
    protected AudioObject[] next;
    protected String name;
    protected int sampleRate;
    protected int channels;
    protected int inputs = 0;
    protected Note currentNote = null;
    protected double currentNoteStartTime;
    protected int numOfSamples = 0;
    protected Instrument inst = null;
    protected boolean finished = true;
    private int returned;

    protected AudioObject(AudioObject audioObject, String string) {
        AudioObject[] audioObjectArray = new AudioObject[]{audioObject};
        this.name = string;
        this.previous = audioObjectArray;
        this.previous[0].setNext(this);
        this.inputs = 1;
    }

    protected AudioObject(AudioObject[] audioObjectArray, String string) {
        this.name = string;
        this.previous = audioObjectArray;
        for (int i = 0; i < audioObjectArray.length; ++i) {
            audioObjectArray[i].setNext(this);
        }
        this.inputs = audioObjectArray.length;
    }

    protected AudioObject(Instrument instrument, int n, String string) {
        this.inst = instrument;
        this.name = string;
        this.sampleRate = n;
        this.inst.addPrimaryAO(this);
    }

    public abstract int work(float[] var1) throws AOException;

    private void setNext(AudioObject audioObject) {
        if (this.next == null) {
            this.next = new AudioObject[1];
            this.next[0] = audioObject;
        } else {
            AudioObject[] audioObjectArray = new AudioObject[this.next.length + 1];
            for (int i = 0; i < this.next.length; ++i) {
                audioObjectArray[i] = this.next[i];
            }
            audioObjectArray[this.next.length] = audioObject;
            this.next = audioObjectArray;
        }
    }

    public int nextWork(float[] fArray) throws AOException {
        this.returned = 0;
        this.returned = this.work(fArray);
        this.inst.setFinished(this.finished);
        return this.returned;
    }

    protected void buildNext(Note note, double d, int n) {
        if (this.next != null) {
            for (int i = 0; i < this.next.length; ++i) {
                this.next[i].numOfSamples = n;
                this.next[i].inst = this.inst;
                this.next[i].channels = this.channels;
                this.next[i].sampleRate = this.sampleRate;
                this.next[i].newNote(note, d, n);
            }
        } else {
            try {
                this.inst.setFinalAO(this);
            }
            catch (AOException aOException) {
                System.out.println(aOException);
                System.exit(1);
            }
        }
    }

    protected void build() {
    }

    public void newNote(Note note, double d, int n) {
        this.currentNote = note;
        this.currentNoteStartTime = d;
        this.numOfSamples = n;
        this.build();
        this.buildNext(this.currentNote, this.currentNoteStartTime, this.numOfSamples);
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getChannels() {
        return this.channels;
    }
}

