/*
 * Decompiled with CFR 0.152.
 */
package jm.audio;

import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioChainListener;
import jm.audio.AudioObject;
import jm.music.data.Note;
import jm.music.rt.RTLine;

public abstract class Instrument
extends Thread
implements Runnable,
JMC {
    public int iterations;
    protected Vector primaryAO;
    protected AudioObject finalAO = null;
    protected int numOfSamples = 0;
    protected int numOfChannels = 0;
    protected int bufsize = 4096;
    protected volatile Vector listeners = new Vector();
    protected long samplesProcessed = 0L;
    private boolean restNote = false;
    private float[] rtBuffer = new float[this.bufsize];
    private boolean finished = true;
    private boolean clear = false;
    private boolean block = true;
    private RTLine rtline;
    private int index = 0;
    public boolean finishedNewData = false;
    private boolean initialised = false;
    private boolean okToRun = true;
    public static final int RENDER = 0;
    public static final int REALTIME = 1;
    protected int output = 0;
    private int returned;
    private float[] buffer;

    protected Instrument() {
        this.primaryAO = new Vector();
    }

    public void renderNote(Note note, double d) {
        this.finalAO = null;
        Enumeration enumeration = this.primaryAO.elements();
        AudioObject audioObject = (AudioObject)this.primaryAO.elementAt(0);
        this.numOfSamples = (int)((float)audioObject.getSampleRate() * (float)note.getDuration());
        this.numOfChannels = audioObject.channels;
        if (note.getFrequency() == -2.147483648E9) {
            this.restNote = true;
        } else {
            double d2 = 0.0;
            d2 = !note.getPitchType() && note.getPitch() != Integer.MIN_VALUE ? JMC.FRQ[note.getPitch()] : note.getFrequency();
            if ((double)audioObject.getSampleRate() * 0.5 < d2) {
                System.out.println("jMusic Instrument error: Sorry, can't render a note above the Nyquist frequency.");
                System.out.println("Sample rate = " + audioObject.getSampleRate() + " Pitch = " + note.getFrequency());
                System.exit(1);
            }
            this.restNote = false;
            while (enumeration.hasMoreElements()) {
                AudioObject audioObject2 = (AudioObject)enumeration.nextElement();
                audioObject2.newNote(note, d - note.getOffset(), this.numOfSamples);
            }
        }
    }

    public void addPrimaryAO(AudioObject audioObject) {
        this.primaryAO.addElement(audioObject);
    }

    public void setFinalAO(AudioObject audioObject) throws AOException {
        if (this.finalAO != null && this.finalAO != audioObject) {
            throw new AOException("jMusic Instrument error: " + audioObject.name, this.finalAO.name + " is already set as finalAO.\n" + "  There can only be one finalAO.");
        }
        this.finalAO = audioObject;
    }

    public void setFinished(boolean bl) {
        if (!this.finished) {
            return;
        }
        this.finished = bl;
    }

    public boolean getFinished() {
        return this.finished;
    }

    public void setBufSize(int n) {
        this.bufsize = n;
        this.rtBuffer = new float[n];
    }

    public int getBufSize() {
        return this.bufsize;
    }

    public int getChannels() {
        try {
            if (!this.getInitialised()) {
                this.createChain();
                this.setInitialised(true);
            }
        }
        catch (AOException aOException) {
            aOException.printStackTrace();
        }
        return ((AudioObject)this.primaryAO.firstElement()).getChannels();
    }

    public int getSampleRate() {
        try {
            if (!this.getInitialised()) {
                this.createChain();
                this.setInitialised(true);
            }
        }
        catch (AOException aOException) {
            aOException.printStackTrace();
        }
        return ((AudioObject)this.primaryAO.firstElement()).getSampleRate();
    }

    public void setInitialised(boolean bl) {
        this.initialised = bl;
    }

    public boolean getInitialised() {
        return this.initialised;
    }

    public void addRTLine(RTLine rTLine) {
        this.rtline = rTLine;
    }

    public Enumeration getListeners() {
        return this.listeners.elements();
    }

    public void addAudioChainListener(AudioChainListener audioChainListener) {
        this.listeners.addElement(audioChainListener);
    }

    public void setController(double[] dArray) {
    }

    public void run() {
        while (true) {
            this.finished = false;
            this.rtline.instNote(this, this.samplesProcessed);
            this.iterateChain();
        }
    }

    public void pause() {
        this.block();
    }

    public void unPause() {
        this.release();
    }

    public void setBlock(boolean bl) {
        this.block = bl;
    }

    public void setClear(boolean bl) {
        this.clear = bl;
    }

    public void setOutput(int n) {
        this.output = n;
    }

    public int getOutput() {
        return this.output;
    }

    public synchronized void release() {
        this.notify();
        this.clear = true;
    }

    public synchronized void block() {
        if (!this.clear && this.block) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.clear = false;
    }

    public abstract void createChain() throws AOException;

    public void iterateChain() {
        this.iterations = 0;
        if (this.numOfSamples > 0) {
            this.iterations = this.numOfSamples * this.numOfChannels;
        }
        this.returned = 0;
        while (!this.finished) {
            int n;
            this.finished = true;
            this.buffer = null;
            if (this.iterations > this.bufsize || this.iterations <= 0) {
                this.buffer = new float[this.bufsize];
                for (n = 0; n < this.buffer.length; ++n) {
                    this.buffer[n] = 0.0f;
                }
            } else {
                this.buffer = new float[this.iterations];
                for (n = 0; n < this.buffer.length; ++n) {
                    this.buffer[n] = 0.0f;
                }
            }
            try {
                this.returned = this.restNote ? this.buffer.length : this.finalAO.nextWork(this.buffer);
            }
            catch (AOException aOException) {
                System.out.println(aOException);
                System.exit(1);
            }
            this.iterations -= this.returned;
            if (this.iterations > 0) {
                this.finished = false;
            }
            this.samplesProcessed += (long)this.returned;
            for (n = 0; n < this.returned; ++n) {
                this.rtBuffer[this.index++] = this.buffer[n];
                if (this.index != this.bufsize) continue;
                this.index = 0;
                Enumeration enumeration = this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    AudioChainListener audioChainListener = (AudioChainListener)enumeration.nextElement();
                    audioChainListener.controlChange(this.rtBuffer, this.returned, this.finished);
                }
                this.block();
            }
        }
    }
}

