/*
 * Decompiled with CFR 0.152.
 */
package jm.audio;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.SourceDataLine;
import jm.audio.AudioChainListener;
import jm.audio.Instrument;
import jm.music.rt.RTLine;

public class RTMixer
implements AudioChainListener {
    private int totLines = 0;
    private int count = 0;
    private float[] sampleArray;
    private ByteArrayOutputStream bos;
    private DataOutputStream dos;
    private SourceDataLine dline;
    protected int sampleRate;
    protected int channels;
    public long currentTime = 0L;
    protected double controlRate = 0.05;
    private double scorePosition = 0.0;
    private RTLine[] rtlines;
    private int bufferSize;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public RTMixer(RTLine[] rTLineArray) {
        this.rtlines = rTLineArray;
        this.sampleRate = rTLineArray[0].getSampleRate();
        this.channels = rTLineArray[0].getChannels();
        this.bufferSize = (int)((double)(this.sampleRate * this.channels) * this.controlRate);
        while (this.bufferSize % 4 != 0) {
            this.controlRate += 0.001;
            this.bufferSize = (int)((double)(this.sampleRate * this.channels) * this.controlRate);
        }
        for (int i = 0; i < rTLineArray.length; ++i) {
            this.totLines += this.rtlines[i].getNumLines();
            this.rtlines[i].setBufferSize(this.bufferSize);
            if (rTLineArray[i].getSampleRate() != this.sampleRate) {
                System.err.println("jMusic RTMixer error: All instruments must have the same sample rate.");
                System.exit(0);
            }
            if (rTLineArray[i].getChannels() == this.channels) continue;
            System.err.println("jMusic RTMixer error: All instruments must have the same number of channels.");
            System.exit(0);
        }
        this.initJMFSound(this.bufferSize);
        this.bos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.bos);
    }

    public synchronized void controlChange(float[] fArray, int n, boolean bl) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = n2;
            this.sampleArray[n3] = this.sampleArray[n3] + fArray[n2];
        }
        if (++this.count == this.totLines) {
            this.scorePosition += this.controlRate;
            for (n2 = 0; n2 < this.rtlines.length; ++n2) {
                Instrument[] instrumentArray = this.rtlines[n2].getInstrument();
                for (int i = 0; i < instrumentArray.length; ++i) {
                    instrumentArray[i].release();
                }
            }
            this.count = 0;
            this.writeOutAudio(this.sampleArray.length);
        }
    }

    public void begin() {
        this.sampleArray = new float[this.bufferSize];
        for (int i = 0; i < this.rtlines.length; ++i) {
            this.rtlines[i].start(this.scorePosition, this);
        }
    }

    public void pause() {
        for (int i = 0; i < this.rtlines.length; ++i) {
            this.rtlines[i].pause();
        }
    }

    public void unPause() {
        for (int i = 0; i < this.rtlines.length; ++i) {
            this.rtlines[i].unPause();
        }
    }

    public void actionLines(Object object, int n) {
        for (int i = 0; i < this.rtlines.length; ++i) {
            this.rtlines[i].externalAction(object, n);
        }
    }

    private void writeOutAudio(int n) {
        int n2;
        this.bos.reset();
        for (n2 = 0; n2 < n; ++n2) {
            if (this.totLines > 1) {
                this.sampleArray[n2] = this.sampleArray[n2] / ((float)this.totLines * 0.75f);
            }
            try {
                this.dos.writeShort((short)(this.sampleArray[n2] * 32767.0f));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.sampleArray[n2] = 0.0f;
        }
        n2 = this.dline.write(this.bos.toByteArray(), 0, this.bos.size());
        this.currentTime += (long)n;
    }

    private void initJMFSound(int n) {
        AudioFormat audioFormat;
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = RTMixer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.sampleRate, 16, this.channels, this.channels * 2, this.sampleRate, true));
        if (!AudioSystem.isLineSupported(info)) {
            System.out.println(info);
            System.err.println("jMusic RTMixer error: JMF Line not supported. Real time audio must be 16 bit stereo ... exiting .. so there : (");
            System.exit(1);
        }
        try {
            this.dline = (SourceDataLine)AudioSystem.getLine(info);
            this.dline.open(audioFormat, n * 8);
            this.dline.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void finalize() {
        try {
            this.dos.close();
            this.bos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

