/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioFileIn {
    private String fileName;
    private File file;
    private AudioFileFormat fileFormat;
    private AudioFormat format;
    private boolean bigEndian;
    private int channels;
    private int sampleRate;
    private long duration;
    private int sampleSize;
    private AudioInputStream is;
    private float[] sampleData;
    private boolean audioFileSpecified = true;

    public AudioFileIn(String string) {
        this.fileName = string;
        try {
            this.file = new File(string);
            this.fileFormat = AudioSystem.getAudioFileFormat(this.file);
            this.format = this.fileFormat.getFormat();
            this.bigEndian = this.format.isBigEndian();
            this.channels = this.format.getChannels();
            this.sampleRate = (int)this.format.getSampleRate();
            this.duration = (long)this.fileFormat.getFrameLength() * (long)this.channels;
            this.sampleSize = this.format.getSampleSizeInBits() / 8;
        }
        catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            System.err.println("jMusic AudioFileIn warning: '" + string + "' may not be an audio file.");
            System.err.println("Reading it in as raw data...");
            this.audioFileSpecified = false;
            this.channels = 1;
            this.sampleSize = 1;
            this.sampleRate = 0;
        }
        catch (IOException iOException) {
            System.err.println("jMusic AudioFileIn error: Cannot read the specified file: " + string);
            System.err.println("Most likely the file does not exist at this location. Exiting...");
            System.exit(0);
        }
    }

    private void readFile() {
        if (this.audioFileSpecified) {
            try {
                this.is = AudioSystem.getAudioInputStream(this.file);
                byte[] byArray = new byte[(int)this.duration * this.sampleSize];
                this.is.read(byArray);
                this.is.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                this.sampleData = new float[(int)this.duration];
                byte[] byArray2 = new byte[this.sampleSize];
                int n = 0;
                while ((long)n < this.duration) {
                    if (byteArrayInputStream.read(byArray2) == -1) {
                        System.out.println("Ran out of samples to read");
                    } else {
                        this.sampleData[n] = this.getFloat(byArray2);
                    }
                    ++n;
                }
                byteArrayInputStream.close();
            }
            catch (UnsupportedAudioFileException unsupportedAudioFileException) {
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            int n;
            Vector<Float> vector = new Vector<Float>();
            try {
                FileInputStream fileInputStream = new FileInputStream(this.fileName);
                n = fileInputStream.read();
                while (n != -1) {
                    vector.addElement(new Float((float)n / 255.0f));
                    n = fileInputStream.read();
                }
                fileInputStream.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                System.exit(1);
            }
            int n2 = vector.size();
            this.sampleData = new float[n2];
            for (n = 0; n < n2; ++n) {
                this.sampleData[n] = ((Float)vector.elementAt(n)).floatValue();
            }
        }
    }

    public int getBitResolution() {
        int n = -1;
        switch (this.sampleSize) {
            case 1: {
                n = 8;
                break;
            }
            case 2: {
                n = 16;
                break;
            }
            case 3: {
                n = 24;
                break;
            }
            case 4: {
                n = 32;
            }
        }
        return n;
    }

    private float getFloat(byte[] byArray) {
        float f = 0.0f;
        int n = 0;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < byArray.length) {
            n |= (byArray[n3] & 0xFF) << (this.bigEndian ? n2 : n3 + 1) * 8 - 8;
            ++n3;
            --n2;
        }
        switch (this.sampleSize) {
            case 1: {
                if (n > 127) {
                    n = ~n + 1;
                    n &= 0x7F;
                    n = ~n + 1;
                }
                f = (float)n / 127.0f;
                break;
            }
            case 2: {
                if (n > Short.MAX_VALUE) {
                    n = ~n + 1;
                    n &= Short.MAX_VALUE;
                    n = ~n + 1;
                }
                f = (float)n / 32767.0f;
                break;
            }
            case 3: {
                if (n > 0x7FFFFF) {
                    n = ~n + 1;
                    n &= 0x7FFFFF;
                    n = ~n + 1;
                }
                f = (float)n / 8388608.0f;
                break;
            }
            case 4: {
                f = (float)n / 2.1474836E9f;
                break;
            }
            default: {
                System.err.println("Format not accepted");
            }
        }
        return f;
    }

    public float[] getSampleData() {
        this.readFile();
        return this.sampleData;
    }

    public int getChannels() {
        return this.channels;
    }

    public String getFileType() {
        if (this.audioFileSpecified) {
            return this.fileFormat.toString();
        }
        return new String("Non-audio");
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleBitDepth() {
        return this.sampleSize * 8;
    }

    public String getEncoding() {
        return this.format.getEncoding().toString();
    }

    public int getDuration() {
        return (int)this.duration;
    }
}

