/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.JMC;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;
import jm.audio.synth.EnvPoint;

public class ADSR
extends AudioObject
implements JMC {
    private EnvPoint[] graphPoints;
    private float[] graphShape;
    private boolean primary;
    private int attack;
    private int decay;
    private int release;
    private double sustain;
    private int totalSamples;
    private int sampleCounter = 0;
    private int position = 0;
    private double attackSamps;
    private double decaySamps;
    private double releaseSamps;
    private double prevRV = 0.0;
    int maxAttackCount;
    int maxDecayCount;

    public ADSR(Instrument instrument, int n, int n2, int n3, int n4, double d, int n5) {
        super(instrument, n, "[ADSR]");
        this.channels = n2;
        this.attack = n3;
        this.decay = n4;
        this.sustain = d;
        this.release = n5;
        this.primary = true;
        this.finished = false;
        this.calcSamps();
    }

    public ADSR(AudioObject audioObject, int n, int n2, double d, int n3) {
        super(audioObject, "[ADSR]");
        this.attack = n;
        this.decay = n2;
        this.sustain = d;
        this.release = n3;
        this.primary = false;
        this.finished = false;
    }

    public int work(float[] fArray) throws AOException {
        if (this.sampleCounter > this.totalSamples * this.channels) {
            this.finished = true;
        }
        if (this.primary) {
            int n = fArray.length;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < this.channels; ++j) {
                    try {
                        fArray[i + j] = this.graphShape[this.position];
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        fArray[i + j] = 0.0f;
                    }
                }
                ++this.position;
            }
            this.sampleCounter += fArray.length;
            return n;
        }
        int n = this.previous[0].nextWork(fArray);
        for (int i = 0; i < fArray.length; i += this.channels) {
            for (int j = 0; j < this.channels; ++j) {
                try {
                    if (this.sampleCounter < this.maxAttackCount) {
                        fArray[i + j] = fArray[i + j] * (float)((double)this.sampleCounter * 1.0 / (double)this.maxAttackCount);
                        continue;
                    }
                    if (this.sampleCounter < this.maxDecayCount + this.maxAttackCount) {
                        fArray[i + j] = fArray[i + j] * (float)(1.0 - (double)(this.sampleCounter - this.maxAttackCount) * (1.0 - this.sustain) / (double)this.maxDecayCount);
                        continue;
                    }
                    if (this.sampleCounter < this.numOfSamples) {
                        fArray[i + j] = fArray[i + j] * (float)this.sustain;
                        continue;
                    }
                    if (this.sampleCounter < this.totalSamples) {
                        fArray[i + j] = fArray[i + j] * (float)(this.sustain - (double)(this.sampleCounter - this.numOfSamples) * this.sustain / this.releaseSamps);
                        continue;
                    }
                    fArray[i + j] = 0.0f;
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    fArray[i + j] = 0.0f;
                }
            }
            ++this.sampleCounter;
            ++this.position;
        }
        return n;
    }

    private void calcSamps() {
        this.attackSamps = this.getSamps(this.attack);
        this.decaySamps = this.getSamps(this.decay);
        this.releaseSamps = this.getSamps(this.release);
    }

    private double getSamps(int n) {
        return (double)n / 1000.0 * (double)this.sampleRate;
    }

    public void build() {
        int n;
        this.sampleCounter = 0;
        this.position = 0;
        if (this.numOfSamples == 0) {
            return;
        }
        if (this.currentNote.getRhythmValue() == this.prevRV) {
            return;
        }
        this.calcSamps();
        this.totalSamples = this.numOfSamples + (int)this.releaseSamps;
        this.graphShape = new float[this.totalSamples];
        this.maxAttackCount = Math.min((int)this.attackSamps, this.numOfSamples);
        double d = 1.0 / (double)this.maxAttackCount;
        for (n = 0; n < this.maxAttackCount; ++n) {
            this.graphShape[n] = (float)(d * (double)n);
        }
        this.maxDecayCount = this.maxAttackCount;
        if (this.sustain < 1.0) {
            this.maxDecayCount = Math.min((int)this.attackSamps + (int)this.decaySamps, this.numOfSamples);
            double d2 = (1.0 - this.sustain) / (double)(this.maxDecayCount - this.maxAttackCount);
            for (int i = this.maxAttackCount; i < this.maxDecayCount; ++i) {
                this.graphShape[i] = (float)(1.0 - d2 * (double)(i - this.maxAttackCount));
            }
        }
        for (n = this.maxDecayCount; n < this.numOfSamples; ++n) {
            this.graphShape[n] = (float)this.sustain;
        }
        double d3 = this.graphShape[this.numOfSamples - 1];
        double d4 = d3 / this.releaseSamps;
        for (int i = this.numOfSamples; i < this.totalSamples; ++i) {
            this.graphShape[i] = (float)(d3 - d4 * (double)(i - this.numOfSamples));
        }
        this.finished = false;
    }
}

