/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import java.util.Random;
import jm.audio.AOException;
import jm.audio.AudioObject;
import jm.audio.Instrument;

public class Noise
extends AudioObject {
    private int noiseType = 0;
    private int noiseDensity = 10;
    private float amp = 1.0f;
    private static float sum;
    private static float[] rg;
    private static int k;
    private static int kg;
    private static int ng;
    private static int threshold;
    private static int np;
    private static int nbits;
    private static int numbPoints;
    private static float nr;
    private static float result;
    private static int counter;
    private double standardDeviation = 0.25;
    private double mean = 0.0;
    private float walkLastValue = 0.0f;
    private float walkStepSize = 0.3f;
    private float walkMax = 1.0f;
    private float walkMin = -1.0f;
    private int walkNoiseDensity = 500;
    private long walkDensityCounter = 0L;
    private boolean walkVaryDensity = true;
    private int walkNoiseDensityMin = 1;
    private int walkNoiseDensityMax = 1500;
    private int walkNoiseDensityStepSize = 100;
    private int gendynAmpGranularity = 100;
    private int gendynPrevTime = 50;
    private int gendynTimeMirror = 100;
    private int gendynAmpMirror = 80;
    private int gendynAmp0 = 0;
    private int gendynTime1 = 50;
    private int gendynAmp1 = 0;
    private int gendynTime2 = 50;
    private int gendynAmp2 = 0;
    private int gendynTime3 = 50;
    private int gendynAmp3 = 0;
    private int[] gendynIntArray;
    private int gendynIntArrayLength;
    private int gendynIntArrayCounter = 0;
    private int gendynTimeStepSize = 4;
    private int maxGendynTimeStepSize = 75;
    private int gendynAmpStepSize = 2;
    private int maxGendynAmpStepSize = 10;
    private boolean gendynGaussian = false;
    private int gendynPrimaryTimeStepSize = 10;
    private int gendynPrimaryAmpStepSize = 10;
    private int gendynPrimaryTimeMirror = 100;
    private int gendynPrimaryAmpMirror = 100;
    public static final int WHITE_NOISE = 0;
    public static final int STEP_NOISE = 1;
    public static final int SMOOTH_NOISE = 2;
    public static final int BROWN_NOISE = 3;
    public static final int FRACTAL_NOISE = 4;
    public static final int GAUSSIAN_NOISE = 5;
    public static final int WALK_NOISE = 6;
    public static final int GENDYN_NOISE = 7;

    public Noise(Instrument instrument) {
        this(instrument, 0);
    }

    public Noise(Instrument instrument, int n) {
        this(instrument, n, 44100);
    }

    public Noise(Instrument instrument, int n, int n2) {
        this(instrument, n, n2, 1);
    }

    public Noise(Instrument instrument, int n, int n2, int n3) {
        super(instrument, n2, "[WaveTable]");
        this.noiseType = n;
        this.channels = n3;
        if (n == 4) {
            this.setUpFractalMath();
        }
        if (n == 7) {
            this.makeGendynArray();
        }
    }

    public void setAmp(float f) {
        this.amp = f;
    }

    public float getAmp() {
        return this.amp;
    }

    private void setUpFractalMath() {
        nr /= 2.0f;
        while (nr > 1.0f) {
            ++nbits;
            np = 2 * np;
            nr /= 2.0f;
        }
        for (kg = 0; kg < nbits; ++kg) {
            Noise.rg[Noise.kg] = (float)Math.random();
        }
    }

    public int work(float[] fArray) throws AOException {
        int n = 0;
        switch (this.noiseType) {
            case 0: {
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        fArray[n++] = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                    }
                }
                break;
            }
            case 3: {
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        float f4 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        float f5 = (f + f2 + f3 + f4) / 4.0f;
                        fArray[n++] = f5;
                        f = f2;
                        f2 = f3;
                        f3 = f4;
                    }
                }
                break;
            }
            case 1: {
                int n2 = this.noiseDensity;
                float f = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        if (n % n2 == 0) {
                            f = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                        }
                        fArray[n++] = f;
                    }
                }
                break;
            }
            case 2: {
                int n3 = this.noiseDensity;
                float f = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                float f6 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        if ((n + 1) % n3 == 0) {
                            fArray[n++] = f6;
                            f = f6;
                            f6 = (float)(Math.random() * 2.0 - 1.0) * this.amp;
                            continue;
                        }
                        fArray[n++] = f + (f6 - f) / (float)n3 * (float)(n % n3);
                    }
                }
                break;
            }
            case 4: {
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        if (counter % this.noiseDensity == 0) {
                            threshold = np;
                            ng = nbits;
                            while (k % threshold != 0) {
                                --ng;
                                threshold /= 2;
                            }
                            sum = 0.0f;
                            for (kg = 0; kg < nbits; ++kg) {
                                if (kg < ng) {
                                    Noise.rg[Noise.kg] = (float)Math.random();
                                }
                                sum += rg[kg];
                            }
                            result = (float)(((double)(sum / (float)nbits) - 0.17) * 2.85 - 1.0);
                            if ((double)result > 1.0) {
                                result = 1.0f;
                            } else if ((double)result < -1.0) {
                                result = -1.0f;
                            }
                        }
                        ++counter;
                        fArray[n++] = result * this.amp;
                    }
                    if (counter <= 67000) continue;
                    counter = 0;
                }
                break;
            }
            case 5: {
                Random random = new Random();
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        float f = (float)(random.nextGaussian() * this.standardDeviation + this.mean);
                        if (f < -1.0f) {
                            f = -1.0f;
                        } else if (f > 1.0f) {
                            f = 1.0f;
                        }
                        fArray[n++] = f * this.amp;
                    }
                }
                break;
            }
            case 6: {
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        fArray[n++] = this.walkLastValue;
                        ++this.walkDensityCounter;
                        if ((int)this.walkDensityCounter % this.walkNoiseDensity != 0) continue;
                        this.walkLastValue += (float)Math.random() * this.walkStepSize * 2.0f - this.walkStepSize;
                        while (this.walkLastValue > this.walkMax || this.walkLastValue < this.walkMin) {
                            if (this.walkLastValue > this.walkMax) {
                                this.walkLastValue -= (this.walkLastValue - this.walkMax) * 2.0f;
                            }
                            if (!(this.walkLastValue < this.walkMin)) continue;
                            this.walkLastValue += (this.walkMin - this.walkLastValue) * 2.0f;
                        }
                        if (!this.walkVaryDensity) continue;
                        this.walkNoiseDensity += (int)(Math.random() * (double)this.walkNoiseDensityStepSize * 2.0 - (double)this.walkNoiseDensityStepSize);
                        if (this.walkNoiseDensity < this.walkNoiseDensityMin) {
                            this.walkNoiseDensity = this.walkNoiseDensityMin;
                            continue;
                        }
                        if (this.walkNoiseDensity <= this.walkNoiseDensityMax) continue;
                        this.walkNoiseDensity = this.walkNoiseDensityMax;
                    }
                }
                break;
            }
            case 7: {
                while (n < fArray.length) {
                    for (int i = 0; i < this.channels; ++i) {
                        fArray[n++] = (float)((double)this.gendynIntArray[this.gendynIntArrayCounter] * 4.0 / (double)this.gendynAmpMirror);
                    }
                    ++this.gendynIntArrayCounter;
                    if (this.gendynIntArrayCounter < this.gendynIntArrayLength) continue;
                    this.makeGendynArray();
                }
                break;
            }
            default: {
                System.err.println(this.name + "jMusic error: Noise type " + this.noiseType + " not supported yet.");
                System.exit(1);
            }
        }
        return n;
    }

    private void makeGendynArray() {
        int n;
        this.gendynTimeStepSize = this.randWalk(this.gendynTimeStepSize, this.gendynPrimaryTimeStepSize, this.gendynPrimaryTimeMirror);
        if (Math.abs(this.gendynTimeStepSize) > this.maxGendynTimeStepSize) {
            this.gendynTimeStepSize = this.maxGendynTimeStepSize;
        }
        this.gendynAmpStepSize = this.randWalk(this.gendynAmpStepSize, this.gendynPrimaryAmpStepSize, this.gendynPrimaryAmpMirror);
        if (Math.abs(this.gendynAmpStepSize) > this.maxGendynAmpStepSize) {
            this.gendynAmpStepSize = this.maxGendynAmpStepSize;
        }
        this.gendynTime1 = Math.abs(this.randWalk(this.gendynTime1, this.gendynTimeStepSize, this.gendynTimeMirror));
        this.gendynAmp1 = this.randWalk(this.gendynAmp1, this.gendynAmpStepSize, this.gendynAmpMirror);
        this.gendynTime2 = Math.abs(this.randWalk(this.gendynTime2, this.gendynTimeStepSize, this.gendynTimeMirror));
        this.gendynAmp2 = this.randWalk(this.gendynAmp2, this.gendynAmpStepSize, this.gendynAmpMirror);
        this.gendynTime3 = Math.abs(this.randWalk(this.gendynTime3, this.gendynTimeStepSize, this.gendynTimeMirror));
        this.gendynAmp3 = this.randWalk(this.gendynAmp3, this.gendynAmpStepSize, this.gendynAmpMirror);
        this.gendynIntArrayLength = this.gendynTime1 + this.gendynTime2 + this.gendynTime3;
        this.gendynIntArray = new int[this.gendynIntArrayLength];
        int n2 = 0;
        int n3 = (this.gendynAmp1 - this.gendynAmp0) / this.gendynTime1;
        for (n = 0; n < this.gendynTime1; ++n) {
            this.gendynIntArray[n2++] = this.gendynAmp0 + n3 * n;
        }
        n3 = (this.gendynAmp2 - this.gendynAmp1) / this.gendynTime2;
        for (n = 0; n < this.gendynTime2; ++n) {
            this.gendynIntArray[n2++] = this.gendynAmp1 + n3 * n;
        }
        n3 = (this.gendynAmp3 - this.gendynAmp2) / this.gendynTime3;
        for (n = 0; n < this.gendynTime3; ++n) {
            this.gendynIntArray[n2++] = this.gendynAmp2 + n3 * n;
        }
        this.gendynAmp0 = this.gendynAmp3;
        this.gendynIntArrayCounter = 0;
    }

    private int randWalk(int n, int n2, int n3) {
        int n4 = 0;
        if (this.gendynGaussian) {
            Random random = new Random();
            n4 = n + (int)(random.nextGaussian() * (double)n2 * 2.0 - (double)n2);
        } else {
            n4 = n + (int)(Math.random() * (double)n2 * 2.0 - (double)n2);
        }
        while (n4 > n3 || n4 < n3 * -1) {
            if (n4 > n3) {
                n4 -= (n4 - n3) * 2;
            }
            if (n4 >= n3 * -1) continue;
            n4 += (n3 * -1 - n4) * 2;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        return n4;
    }

    public void setNoiseDensity(int n) {
        this.noiseDensity = n;
    }

    public void setStandardDeviation(double d) {
        this.standardDeviation = d;
    }

    public void setMean(double d) {
        this.mean = d;
    }

    public void setWalkStepSize(double d) {
        if (d > 0.0) {
            this.walkStepSize = (float)d;
        } else {
            System.err.println("Walk step size must be greater than zero.");
        }
    }

    public void setWalkMax(double d) {
        if (d > 0.0) {
            this.walkMax = (float)d;
        } else {
            System.err.println("Walk maximum value must be greater than zero.");
        }
    }

    public void setWalkMin(double d) {
        if (d < 0.0) {
            this.walkMin = (float)d;
        } else {
            System.err.println("Walk minimum value must be less than zero.");
        }
    }

    public void setWalkNoiseDensity(int n) {
        if (n > 0) {
            this.walkNoiseDensity = n;
        } else {
            System.err.println("walkNoiseDensity must be greater than zero.");
        }
    }

    public void setWalkVaryDensity(boolean bl) {
        this.walkVaryDensity = bl;
    }

    public void setWalkNoiseDensityMin(int n) {
        if (n > 0) {
            this.walkNoiseDensityMin = n;
        } else {
            System.err.println("walkNoiseDensityMin must be greater than zero.");
        }
    }

    public void setWalkNoiseDensityMax(int n) {
        if (n > 0) {
            this.walkNoiseDensityMax = n;
        } else {
            System.err.println("walkNoiseDensityMax must be greater than zero.");
        }
    }

    public void setWalkNoiseDensityStepSize(int n) {
        if (n > 0) {
            this.walkNoiseDensityStepSize = n;
        } else {
            System.err.println("walkNoiseDensityMax must be greater than zero.");
        }
    }

    public void setGendynTimeMirror(double d) {
        if (d > 0.0) {
            this.gendynTimeMirror = (int)d;
        }
    }

    public void setGendynAmpMirror(double d) {
        if (d > 0.0) {
            this.gendynAmpMirror = (int)d;
        }
    }

    public int getGendynAmp0() {
        return this.gendynAmp0;
    }

    public int getGendynAmp1() {
        return this.gendynAmp1;
    }

    public int getGendynAmp2() {
        return this.gendynAmp2;
    }

    public int getGendynAmp3() {
        return this.gendynAmp3;
    }

    public int getGendynTime1() {
        return this.gendynTime1;
    }

    public int getGendynTime2() {
        return this.gendynTime2;
    }

    public int getGendynTime3() {
        return this.gendynTime3;
    }

    public int getGendynAmpStepSize() {
        return this.gendynAmpStepSize;
    }

    public int getGendynTimeStepSize() {
        return this.gendynTimeStepSize;
    }

    public void setGendynAmpStepSize(int n) {
        if (n >= 0) {
            this.gendynAmpStepSize = n;
        }
    }

    public void setMaxGendynAmpStepSize(int n) {
        if (n >= 0) {
            this.maxGendynAmpStepSize = n;
        }
    }

    public void setGendynTimeStepSize(int n) {
        if (n >= 0) {
            this.gendynTimeStepSize = n;
        }
    }

    public void setMaxGendynTimeStepSize(int n) {
        if (n >= 0) {
            this.maxGendynTimeStepSize = n;
        }
    }

    public void setGendynPrimaryAmpStepSize(int n) {
        if (n >= 0) {
            this.gendynPrimaryAmpStepSize = n;
        }
    }

    public void setGendynPrimaryTimeStepSize(int n) {
        if (n >= 0) {
            this.gendynPrimaryTimeStepSize = n;
        }
    }

    public void setGendynAmpGranularity(int n) {
        if (n > 0) {
            this.gendynAmpGranularity = n;
        }
    }

    public void setGendynPrimaryTimeMirror(int n) {
        if (n >= 0) {
            this.gendynPrimaryTimeMirror = n;
        }
    }

    public void setGendynPrimaryAmpMirror(int n) {
        if (n >= 0) {
            this.gendynPrimaryAmpMirror = n;
        }
    }

    public void setGendynGaussian(boolean bl) {
        this.gendynGaussian = bl;
    }

    static {
        rg = new float[16];
        np = 1;
        nbits = 1;
        numbPoints = 48000;
        nr = numbPoints;
        counter = 0;
    }
}

