/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Smooth
extends AudioObject {
    private float[] prevSampleValues;

    public Smooth(AudioObject audioObject) {
        super(audioObject, "[Smooth]");
    }

    public void build() {
        this.prevSampleValues = new float[this.channels];
        for (int i = 0; i < this.prevSampleValues.length; ++i) {
            this.prevSampleValues[i] = 0.0f;
        }
    }

    public int work(float[] fArray) throws AOException {
        int n = this.previous[0].nextWork(fArray);
        for (int i = 0; i < n; i += this.channels) {
            for (int j = 0; j < this.channels; ++j) {
                fArray[i + j] = fArray[i + j] * 0.5f + this.prevSampleValues[j] * 0.5f;
                this.prevSampleValues[j] = fArray[i + j];
            }
        }
        return n;
    }
}

