/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Volume
extends AudioObject {
    float mainVolume = 1.0f;
    float volume = 1.0f;
    double linearVolumeValue = 1.0;

    public Volume(AudioObject audioObject) {
        this(audioObject, 1.0f);
    }

    public Volume(AudioObject audioObject, double d) {
        this(audioObject, (float)d);
    }

    public Volume(AudioObject audioObject, float f) {
        super(audioObject, "[Volume]");
        this.mainVolume = f;
    }

    public void build() {
        this.linearVolumeValue = (double)this.currentNote.getDynamic() / 127.0;
        this.volume = (float)(1.0 - Math.log(128.0 - (double)this.currentNote.getDynamic()) * 0.2) * this.mainVolume;
    }

    public int work(float[] fArray) throws AOException {
        int n = this.previous[0].nextWork(fArray);
        if (this.inputs == 2) {
            float[] fArray2 = new float[fArray.length];
            if (n != this.previous[1].nextWork(fArray2)) {
                throw new AOException(this.name, 0);
            }
            for (int i = 0; i < n; ++i) {
                fArray[i] = fArray[i] * fArray2[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                fArray[i] = fArray[i] * this.volume;
            }
        }
        return n;
    }

    public void setVolume(double d) {
        this.linearVolumeValue = d;
        this.volume = (float)Math.min(1.0, Math.abs(Math.log(1.0 - d) * 0.2));
    }

    public double getVolume() {
        return this.linearVolumeValue;
    }
}

