/*
 * Decompiled with CFR 0.152.
 */
package jm.audio.synth;

import jm.audio.AOException;
import jm.audio.AudioObject;

public final class Waveshaper
extends AudioObject {
    private int shapeType = 1;
    private int stages = 4;
    private double[] weights;
    public static final int POLYNOMIAL = 0;
    public static final int CHEBYSHEV = 1;

    public Waveshaper(AudioObject audioObject) {
        super(audioObject, "[Waveshaper]");
        this.shapeType = 1;
        this.stages = 4;
        double[] dArray = new double[]{0.3, 0.8, 0.6, 0.4};
        this.weights = dArray;
    }

    public Waveshaper(AudioObject audioObject, int n, int n2) {
        super(audioObject, "[Waveshaper]");
        this.shapeType = n;
        this.stages = n2;
        double[] dArray = new double[]{0.3, 0.8, 0.6, 0.4};
        this.weights = dArray;
    }

    public Waveshaper(AudioObject audioObject, int n, int n2, double[] dArray) {
        super(audioObject, "[Waveshaper]");
        this.shapeType = n;
        this.stages = n2;
        this.weights = dArray;
    }

    public int work(float[] fArray) throws AOException {
        int n;
        block16: {
            block15: {
                n = this.previous[0].nextWork(fArray);
                if (this.shapeType != 0) break block15;
                for (int i = 0; i < n; ++i) {
                    float f;
                    float f2 = f = Math.abs(fArray[i]);
                    for (int j = 1; j < this.stages; ++j) {
                        float f3 = f;
                        for (int k = 0; k < j; ++k) {
                            f3 *= f;
                        }
                        f2 = (float)((double)f2 + (double)f3 * this.weights[j]);
                    }
                    if ((double)fArray[i] < 0.0) {
                        f2 *= -1.0f;
                    }
                    fArray[i] = f2;
                }
                break block16;
            }
            if (this.shapeType != 1) break block16;
            for (int i = 0; i < n; ++i) {
                float f;
                float f4 = f = Math.abs(fArray[i]);
                if (this.stages > 1) {
                    f4 = (float)((double)f4 + this.weights[0] * (double)(2.0f * f * f - 1.0f));
                }
                if (this.stages > 2) {
                    f4 = (float)((double)f4 + this.weights[1] * (double)(4.0f * (float)Math.pow(f, 3.0) - 3.0f * f));
                }
                if (this.stages > 3) {
                    f4 = (float)((double)f4 + this.weights[2] * (double)(8.0f * (float)Math.pow(f, 4.0) - 8.0f * (float)Math.pow(f, 2.0) + 1.0f));
                }
                if (this.stages > 4) {
                    f4 = (float)((double)f4 + this.weights[3] * (double)(16.0f * (float)Math.pow(f, 5.0) - 20.0f * (float)Math.pow(f, 3.0) + 5.0f * f));
                }
                if (this.stages > 5) {
                    f4 = (float)((double)f4 + this.weights[4] * (double)(32.0f * (float)Math.pow(f, 6.0) - 48.0f * (float)Math.pow(f, 4.0) + 18.0f * (float)Math.pow(f, 2.0) - 1.0f));
                }
                if (this.stages > 6) {
                    f4 = (float)((double)f4 + this.weights[5] * (double)(64.0f * (float)Math.pow(f, 7.0) - 112.0f * (float)Math.pow(f, 5.0) + 56.0f * (float)Math.pow(f, 3.0) - 7.0f * f));
                }
                if (this.stages > 7) {
                    f4 = (float)((double)f4 + this.weights[6] * (double)(128.0f * (float)Math.pow(f, 8.0) - 256.0f * (float)Math.pow(f, 6.0) + 160.0f * (float)Math.pow(f, 4.0) - 32.0f * (float)Math.pow(f, 2.0) + 1.0f));
                }
                if (this.stages > 8) {
                    f4 = (float)((double)f4 + this.weights[7] * (double)(256.0f * (float)Math.pow(f, 9.0) - 576.0f * (float)Math.pow(f, 7.0) + 432.0f * (float)Math.pow(f, 5.0) - 120.0f * (float)Math.pow(f, 3.0) + 9.0f * f));
                }
                if (this.stages > 9) {
                    f4 = (float)((double)f4 + this.weights[8] * (double)(512.0f * (float)Math.pow(f, 10.0) - 1280.0f * (float)Math.pow(f, 8.0) + 1120.0f * (float)Math.pow(f, 6.0) - 400.0f * (float)Math.pow(f, 4.0) + 50.0f * (float)Math.pow(f, 2.0) - 1.0f));
                }
                if ((double)fArray[i] < 0.0) {
                    f4 *= -1.0f;
                }
                fArray[i] = f4;
            }
        }
        return n;
    }
}

