/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Button;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.StringTokenizer;
import jm.music.data.Note;
import jm.music.data.Phrase;

public class CpnZoomScreen
extends Dialog
implements ActionListener,
WindowListener {
    private Phrase phrase;
    private Phrase beforeZoom;
    private Phrase afterZoom;
    private static TextField startMeasureEdit = new TextField(8);
    private static TextField measureCountEdit = new TextField(8);
    private static Label startMeasureLabel = new Label("Start at Measure");
    private static Label measureCountLabel = new Label("Number of Measures");
    private Button okButton = new Button("Update View:");
    private Button cancelButton = new Button("Cancel");

    public CpnZoomScreen(Frame frame) {
        super(frame, "Select the Measures to Show", true);
        this.setSize(500, 400);
        this.placeControls();
        this.addWindowListener(this);
        this.setVisible(false);
        this.pack();
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void zoomIn(Phrase phrase, Phrase phrase2, Phrase phrase3) {
        this.phrase = phrase2;
        this.beforeZoom = phrase;
        this.afterZoom = phrase3;
        this.beforeZoom.empty();
        this.afterZoom.empty();
        this.setLocation(20, 20);
        this.show();
    }

    public static void zoomOut(Phrase phrase, Phrase phrase2, Phrase phrase3) {
        int n;
        for (n = 0; n < phrase2.size(); ++n) {
            phrase.addNote(phrase2.getNote(n));
        }
        for (n = 0; n < phrase3.size(); ++n) {
            phrase.addNote(phrase3.getNote(n));
        }
        phrase2.empty();
        for (n = 0; n < phrase.size(); ++n) {
            phrase2.addNote(phrase.getNote(n));
        }
        phrase.empty();
        phrase3.empty();
    }

    private void placeControls() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(startMeasureLabel, gridBagConstraints);
        this.add(startMeasureLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(startMeasureEdit, gridBagConstraints);
        this.add(startMeasureEdit);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(measureCountLabel, gridBagConstraints);
        this.add(measureCountLabel);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(measureCountEdit, gridBagConstraints);
        this.add(measureCountEdit);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        gridBagLayout.setConstraints(this.okButton, gridBagConstraints);
        this.add(this.okButton);
        this.okButton.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 1;
        this.add(this.cancelButton);
        gridBagLayout.setConstraints(this.cancelButton, gridBagConstraints);
        this.cancelButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.okButton) {
            if (this.startFieldError()) {
                startMeasureEdit.setText("Error");
            } else if (this.countFieldError()) {
                measureCountEdit.setText("Error");
            } else {
                this.zoom();
                this.dispose();
            }
        }
        if (actionEvent.getSource() == this.cancelButton) {
            this.dispose();
        }
    }

    private double countMeasures(Phrase phrase) {
        double d = 0.0;
        for (int i = 0; i < phrase.size(); ++i) {
            d += phrase.getNote(i).getRhythmValue();
        }
        return d / (double)phrase.getNumerator();
    }

    private static boolean intFieldError(TextField textField, double d, double d2) {
        StringTokenizer stringTokenizer = new StringTokenizer(textField.getText());
        if (!stringTokenizer.hasMoreElements()) {
            textField.setText("Error");
            return true;
        }
        String string = stringTokenizer.nextToken();
        try {
            int n = new Integer(string);
            if ((double)n < d) {
                textField.setText("Error");
                return true;
            }
            if ((double)n > d2) {
                textField.setText("Error");
                return true;
            }
        }
        catch (Throwable throwable) {
            textField.setText("Error");
            return true;
        }
        if (stringTokenizer.hasMoreElements()) {
            textField.setText("Error");
            return true;
        }
        return false;
    }

    private static int getIntegerValue(TextField textField) {
        StringTokenizer stringTokenizer = new StringTokenizer(textField.getText());
        String string = stringTokenizer.nextToken();
        return new Integer(string);
    }

    private boolean startFieldError() {
        return CpnZoomScreen.intFieldError(startMeasureEdit, 1.0, this.countMeasures(this.phrase) + 0.99);
    }

    private boolean countFieldError() {
        return CpnZoomScreen.intFieldError(measureCountEdit, 1.0, 99999.99);
    }

    private void moveMeasures(Phrase phrase, Phrase phrase2, double d) {
        double d2;
        for (double d3 = d * (double)phrase.getNumerator(); d3 > 0.005 && phrase.size() > 0; d3 -= d2) {
            Note note = phrase.getNote(0);
            d2 = note.getRhythmValue();
            phrase2.addNote(note);
            phrase.removeNote(0);
        }
    }

    private void moveAll(Phrase phrase, Phrase phrase2) {
        while (phrase.size() > 0) {
            Note note = phrase.getNote(0);
            phrase2.addNote(note);
            phrase.removeNote(0);
        }
    }

    private void zoom() {
        int n = CpnZoomScreen.getIntegerValue(startMeasureEdit) - 1;
        int n2 = CpnZoomScreen.getIntegerValue(measureCountEdit);
        this.beforeZoom.empty();
        this.afterZoom.empty();
        this.moveMeasures(this.phrase, this.beforeZoom, n);
        this.moveAll(this.phrase, this.afterZoom);
        this.moveMeasures(this.afterZoom, this.phrase, (double)(n + n2) - this.countMeasures(this.beforeZoom));
    }
}

