/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.Vector;
import javax.swing.JPanel;
import jm.JMC;
import jm.gui.cpn.JStaveActionHandler;
import jm.gui.cpn.KeyChangeListener;
import jm.music.data.Phrase;
import jm.music.tools.ChordAnalysis;
import jm.music.tools.PhraseAnalysis;

public class JGrandStave
extends JPanel
implements JMC {
    private int tonic = 0;
    RGBImageFilter filter = new RGBImageFilter(){
        {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 | 0xFFFF0000;
        }
    };
    public static final int[] keys = new int[]{11, 6, 1, 8, 3, 10, 5, 0, 7, 2, 9, 4, 11, 6, 1};
    protected int[] scale = JMC.MAJOR_SCALE;
    private boolean isNormalColor = true;
    protected KeyChangeListener keyChangeListener = null;
    public Image image;
    protected Graphics g;
    protected RedFilter crotchetUp = new RedFilter();
    protected RedFilter crotchetDown = new RedFilter();
    protected RedFilter quaverDown = new RedFilter();
    protected RedFilter quaverUp = new RedFilter();
    protected RedFilter semiquaverDown = new RedFilter();
    protected RedFilter semiquaverUp = new RedFilter();
    protected RedFilter minimDown = new RedFilter();
    protected RedFilter minimUp = new RedFilter();
    protected RedFilter semibreve = new RedFilter();
    protected RedFilter dot = new RedFilter();
    protected RedFilter semiquaverRest = new RedFilter();
    protected RedFilter quaverRest = new RedFilter();
    protected RedFilter crotchetRest = new RedFilter();
    protected RedFilter minimRest = new RedFilter();
    protected RedFilter semibreveRest = new RedFilter();
    protected RedFilter sharp = new RedFilter();
    protected RedFilter flat = new RedFilter();
    protected RedFilter natural = new RedFilter();
    protected RedFilter delete = new RedFilter();
    protected RedFilter tie = new RedFilter(Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/tie.gif")));
    protected Image trebleClef;
    protected Image bassClef;
    protected Image one;
    protected Image two;
    protected Image three;
    protected Image four;
    protected Image five;
    protected Image six;
    protected Image seven;
    protected Image eight;
    protected Image nine;
    public int staveSpaceHeight = 8;
    public int rightMargin = 20;
    public int beatWidth = 43;
    public int staveWidth = this.beatWidth * 15;
    public int imageHeightOffset = 28;
    public int clefWidth = 38;
    public int timeSigWidth = 5;
    public int keySigWidth = 5;
    public int bPos = 28;
    protected Phrase phrase;
    protected RedFilter currImage;
    protected int currBeatWidth;
    protected int totalBeatWidth;
    protected boolean dottedNote = false;
    protected int[] notePosOffset = new int[]{24, 24, 20, 20, 16, 12, 12, 8, 8, 4, 4, 0};
    protected double metre = 4.0;
    protected int keySignature = 0;
    protected int[] sharps = new int[]{77, 72, 79, 74, 69, 76, 71};
    protected int[] flats = new int[]{71, 76, 69, 74, 67, 72, 65};
    protected Vector previouslyChromatic = new Vector();
    protected int[] lineNotes = new int[]{0, 1, 4, 7, 8, 11, 14, 15, 17, 18, 21, 22};
    public Vector notePositions = new Vector();
    protected int maxPitch = 127;
    protected int minPitch = 0;
    protected String title;
    protected boolean barNumbers = false;
    protected boolean editable = true;
    protected boolean qtOn = false;
    protected int panelHeight = 110;
    protected int staveDelta = 0;
    public static final int MAX_HEIGHT = 500;
    public static final int MAX_WIDTH = 2000;
    private double beatCounter;
    private boolean isFirstNoteInTie = true;
    private boolean isNote = false;
    private boolean firstAccidentalDisplayed = false;
    private boolean isTied = false;
    private boolean isUp = true;
    private boolean semitoneShiftUp = false;
    private boolean extraImagesUsed;
    private boolean requiresMoreThanOneImage;
    private double excessRhythmValue;
    private int savedBeatWidth;
    private int savedBeatWidth2;
    private int lastChordDisplayed = -1;
    private int lastPosition = 0;
    private int[] firstChords = new int[0];
    private int[] secondChords = new int[0];
    private String[] chordStrings = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "."};
    static /* synthetic */ Class class$jm$gui$cpn$Stave;

    public JGrandStave() {
        this(new Phrase());
        this.bPos = 110;
        this.panelHeight = 310;
        this.setSize(this.beatWidth * 40, this.panelHeight);
    }

    public JGrandStave(Phrase phrase) {
        this.phrase = phrase;
        this.title = phrase.getTitle();
        this.setBackground(Color.getHSBColor(0.14f, 0.09f, 1.0f));
        this.setSize(this.beatWidth * 40, this.panelHeight);
        if (this.getSize().width < (int)(phrase.getEndTime() * (double)this.beatWidth * 1.5)) {
            this.setSize((int)(phrase.getEndTime() * (double)this.beatWidth * 1.5), this.panelHeight);
        }
        JStaveActionHandler jStaveActionHandler = new JStaveActionHandler(this);
        this.addMouseListener(jStaveActionHandler);
        this.addMouseMotionListener(jStaveActionHandler);
        try {
            this.trebleClef = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/trebleClef.gif"));
            this.bassClef = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/bassClef.gif"));
            this.crotchetDown.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/crotchetDown.gif"));
            this.crotchetUp.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/crotchetUp.gif"));
            this.quaverDown.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/quaverDown.gif"));
            this.quaverUp.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/quaverUp.gif"));
            this.semiquaverDown.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/semiquaverDown.gif"));
            this.semiquaverUp.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/semiquaverUp.gif"));
            this.minimDown.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/minimDown.gif"));
            this.minimUp.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/minimUp.gif"));
            this.semibreve.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/semibreve.gif"));
            this.dot.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/dot.gif"));
            this.semiquaverRest.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/semiquaverRest.gif"));
            this.quaverRest.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/quaverRest.gif"));
            this.crotchetRest.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/crotchetRest.gif"));
            this.minimRest.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/minimRest.gif"));
            this.semibreveRest.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/semibreveRest.gif"));
            this.sharp.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/sharp.gif"));
            this.flat.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/flat.gif"));
            this.natural.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/natural.gif"));
            this.one = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/one.gif"));
            this.two = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/two.gif"));
            this.three = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/three.gif"));
            this.four = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/four.gif"));
            this.five = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/five.gif"));
            this.six = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/six.gif"));
            this.seven = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/seven.gif"));
            this.eight = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/eight.gif"));
            this.nine = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/nine.gif"));
            this.delete.image = Toolkit.getDefaultToolkit().getImage((class$jm$gui$cpn$Stave == null ? (class$jm$gui$cpn$Stave = JGrandStave.class$("jm.gui.cpn.Stave")) : class$jm$gui$cpn$Stave).getResource("graphics/delete.gif"));
        }
        catch (Exception exception) {
            System.out.println("Error while loading pictures...");
            exception.printStackTrace();
        }
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            {
                this.canFilterIndexColorModel = true;
            }

            public int filterRGB(int n, int n2, int n3) {
                return n3 | 0xFFFF0000;
            }
        };
        this.crotchetDown.redImage = this.createImage(new FilteredImageSource(this.crotchetDown.image.getSource(), rGBImageFilter));
        this.crotchetUp.redImage = this.createImage(new FilteredImageSource(this.crotchetUp.image.getSource(), rGBImageFilter));
        this.quaverDown.redImage = this.createImage(new FilteredImageSource(this.quaverDown.image.getSource(), rGBImageFilter));
        this.quaverUp.redImage = this.createImage(new FilteredImageSource(this.quaverUp.image.getSource(), rGBImageFilter));
        this.semiquaverDown.redImage = this.createImage(new FilteredImageSource(this.semiquaverDown.image.getSource(), rGBImageFilter));
        this.semiquaverUp.redImage = this.createImage(new FilteredImageSource(this.semiquaverUp.image.getSource(), rGBImageFilter));
        this.minimDown.redImage = this.createImage(new FilteredImageSource(this.minimDown.image.getSource(), rGBImageFilter));
        this.minimUp.redImage = this.createImage(new FilteredImageSource(this.minimUp.image.getSource(), rGBImageFilter));
        this.semibreve.redImage = this.createImage(new FilteredImageSource(this.semibreve.image.getSource(), rGBImageFilter));
        this.dot.redImage = this.createImage(new FilteredImageSource(this.dot.image.getSource(), rGBImageFilter));
        this.semiquaverRest.redImage = this.createImage(new FilteredImageSource(this.semiquaverRest.image.getSource(), rGBImageFilter));
        this.quaverRest.redImage = this.createImage(new FilteredImageSource(this.quaverRest.image.getSource(), rGBImageFilter));
        this.crotchetRest.redImage = this.createImage(new FilteredImageSource(this.crotchetRest.image.getSource(), rGBImageFilter));
        this.minimRest.redImage = this.createImage(new FilteredImageSource(this.minimRest.image.getSource(), rGBImageFilter));
        this.sharp.redImage = this.createImage(new FilteredImageSource(this.sharp.image.getSource(), rGBImageFilter));
        this.flat.redImage = this.createImage(new FilteredImageSource(this.flat.image.getSource(), rGBImageFilter));
        this.natural.redImage = this.createImage(new FilteredImageSource(this.natural.image.getSource(), rGBImageFilter));
        this.delete.redImage = this.createImage(new FilteredImageSource(this.delete.image.getSource(), rGBImageFilter));
        this.bPos = 110;
        this.panelHeight = 310;
        this.setSize(this.beatWidth * 40, this.panelHeight);
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.phrase == null) {
            return;
        }
        if (this.image == null) {
            this.image = this.createImage(2000, 500);
            this.g = this.image.getGraphics();
        }
        this.beatCounter = 0.0;
        this.previouslyChromatic.removeAllElements();
        this.notePositions.removeAllElements();
        int n6 = 0;
        if (this.title != null) {
            this.g.drawString(this.title, this.rightMargin, this.bPos - 50);
        }
        int n7 = 0;
        if (this.keySignature > 0 && this.keySignature < 8) {
            for (n5 = 0; n5 < this.keySignature; ++n5) {
                n4 = this.notePosOffset[this.sharps[n5] % 12] + this.bPos - 4 + (5 - this.sharps[n5] / 12) * 24 + (6 - this.sharps[n5] / 12) * 4;
                this.g.drawImage(this.sharp.image, this.rightMargin + this.clefWidth + n7, n4, this);
                this.g.drawImage(this.sharp.image, this.rightMargin + this.clefWidth + n7, n4 + this.staveSpaceHeight * 7, this);
                n7 += 10;
                n3 = this.sharps[n5] % 12;
                for (n2 = 0; n2 < 128; ++n2) {
                    if (n2 % 12 != n3) continue;
                    this.previouslyChromatic.addElement(new Integer(n2));
                    ++n6;
                }
                this.keySigWidth = n7;
            }
        } else if (this.keySignature < 0 && this.keySignature > -8) {
            for (n5 = 0; n5 < Math.abs(this.keySignature); ++n5) {
                n4 = this.notePosOffset[this.flats[n5] % 12] + this.bPos - 4 + (5 - this.flats[n5] / 12) * 24 + (6 - this.flats[n5] / 12) * 4;
                this.g.drawImage(this.flat.image, this.rightMargin + this.clefWidth + n7, n4, this);
                this.g.drawImage(this.flat.image, this.rightMargin + this.clefWidth + n7, n4 + this.staveSpaceHeight * 7, this);
                n7 += 10;
                n3 = this.flats[n5] % 12;
                for (n2 = 0; n2 < 128; ++n2) {
                    if (n2 % 12 != n3) continue;
                    this.previouslyChromatic.addElement(new Integer(n2));
                    ++n6;
                }
            }
        }
        this.keySigWidth = n7 + 3;
        if (this.metre != 0.0) {
            Image[] imageArray = new Image[]{this.one, this.two, this.three, this.four, this.five, this.six, this.seven, this.eight, this.nine};
            this.g.drawImage(imageArray[(int)this.metre - 1], this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 13, this);
            this.g.drawImage(imageArray[(int)this.metre - 1], this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 13 + this.staveSpaceHeight * 6, this);
            this.g.drawImage(this.four, this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 29, this);
            this.g.drawImage(this.four, this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 29 + this.staveSpaceHeight * 6, this);
            this.timeSigWidth = 30;
        } else {
            this.timeSigWidth = 5;
        }
        this.totalBeatWidth = this.rightMargin + this.clefWidth + this.keySigWidth + this.timeSigWidth;
        this.firstChords = ChordAnalysis.getFirstPassChords(this.phrase, 1.0, this.tonic, this.scale);
        this.secondChords = ChordAnalysis.getSecondPassChords(this.phrase, 1.0, this.tonic, this.scale);
        this.lastChordDisplayed = -1;
        for (n = 0; n < this.phrase.size(); ++n) {
            double d;
            n4 = this.phrase.getNote(n).getPitch();
            n3 = n4 == Integer.MIN_VALUE || this.phrase.getNote(n).getRhythmValue() == 0.0 ? this.notePosOffset[11] + this.bPos - 4 + 0 + 4 : this.notePosOffset[n4 % 12] + this.bPos - 4 + (5 - n4 / 12) * 24 + (6 - n4 / 12) * 4;
            this.isNormalColor = n4 == Integer.MIN_VALUE || PhraseAnalysis.isScale(this.phrase.getNote(n), this.tonic, this.scale);
            this.firstAccidentalDisplayed = false;
            this.semitoneShiftUp = false;
            this.isTied = false;
            this.isFirstNoteInTie = true;
            this.extraImagesUsed = false;
            this.savedBeatWidth = this.totalBeatWidth;
            this.savedBeatWidth2 = 0;
            double d2 = this.metre - this.beatCounter % this.metre;
            for (d = this.phrase.getNote(n).getRhythmValue(); d2 < d; d -= d2) {
                this.isTied = true;
                this.drawNote(n4, d2, n3, n6);
                d2 = this.metre - this.beatCounter % this.metre;
            }
            this.drawNote(n4, d, n3, n6);
        }
        for (n = 0; n < 5; ++n) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight);
        }
        for (n = 6; n < 11; ++n) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight);
        }
        this.g.setColor(Color.darkGray);
        for (n = -7; n < -2; ++n) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight);
        }
        for (n = 13; n < 18; ++n) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight);
        }
        this.g.setColor(Color.lightGray);
        for (n = 0; n < 5; ++n) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight, this.totalBeatWidth + 50, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight);
        }
        for (n = 6; n < 11; ++n) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight, this.totalBeatWidth + 50, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight);
        }
        this.g.setColor(Color.black);
        this.g.drawImage(this.trebleClef, this.rightMargin + 7, this.bPos - 4, this);
        this.g.drawImage(this.bassClef, this.rightMargin + 7, this.bPos + this.staveSpaceHeight * 6, this);
        graphics.drawImage(this.image, 0, 0, null);
        this.g.setColor(this.getBackground());
        this.g.fillRect(0, 0, 2000, 500);
        this.g.setColor(this.getForeground());
    }

    private void drawNote(int n, double d, int n2, int n3) {
        this.requiresMoreThanOneImage = false;
        this.excessRhythmValue = 0.0;
        if (this.beatCounter % 1.0 == 0.0) {
            int n4;
            int n5 = (int)(this.beatCounter / 1.0);
            int n6 = n4 = n5 - this.lastChordDisplayed;
            while (this.lastChordDisplayed < n5) {
                ++this.lastChordDisplayed;
                this.g.drawString(this.chordStrings[this.firstChords[this.lastChordDisplayed]], (int)((double)this.totalBeatWidth - (double)(this.totalBeatWidth - this.lastPosition) * ((double)(--n6) / (double)n4)), 20);
                int n7 = this.secondChords[this.lastChordDisplayed];
                String string = this.chordStrings[n7];
                this.g.drawString(string, (int)((double)this.totalBeatWidth - (double)(this.totalBeatWidth - this.lastPosition) * ((double)n6 / (double)n4)), 40);
            }
            this.lastPosition = this.totalBeatWidth;
        }
        this.chooseImage(n, d, 71, 60, 50);
        this.drawNote2(n, d - this.excessRhythmValue, n2, n3);
        if (this.requiresMoreThanOneImage) {
            this.drawNote(n, this.excessRhythmValue, n2, n3);
            this.extraImagesUsed = true;
        }
    }

    private void drawNote2(int n, double d, int n2, int n3) {
        int n4;
        int n5;
        if ((n % 12 == 1 || n % 12 == 3 || n % 12 == 6 || n % 12 == 8 || n % 12 == 10) && n != Integer.MIN_VALUE && d != 0.0) {
            if (this.keySignature > -1) {
                if (!this.firstAccidentalDisplayed) {
                    this.displayImage(this.g, this.sharp, this.totalBeatWidth - 9, n2);
                }
                this.previouslyChromatic.addElement(new Integer(n - 1));
            } else {
                n2 -= 4;
                if (!this.firstAccidentalDisplayed) {
                    this.displayImage(this.g, this.flat, this.totalBeatWidth - 9, n2);
                }
                this.previouslyChromatic.addElement(new Integer(n + 1));
                ++n;
                this.semitoneShiftUp = true;
            }
        } else {
            n5 = this.previouslyChromatic.size();
            for (n4 = 0; n4 < n5; ++n4) {
                Integer n6 = (Integer)this.previouslyChromatic.elementAt(n4);
                if (n6 != n || n == Integer.MIN_VALUE || d == 0.0) continue;
                if (!this.firstAccidentalDisplayed) {
                    this.displayImage(this.g, this.natural, this.totalBeatWidth - 7, n2);
                }
                if (n4 > n3 - 1) {
                    this.previouslyChromatic.removeElementAt(n4);
                }
                n4 = n5;
            }
        }
        this.firstAccidentalDisplayed = true;
        this.displayImage(this.g, this.currImage, this.totalBeatWidth, n2);
        this.notePositions.addElement(new Integer(this.totalBeatWidth));
        this.notePositions.addElement(new Integer(n2));
        if (this.dottedNote) {
            n5 = 1;
            for (n4 = 0; n4 < this.lineNotes.length; ++n4) {
                if (this.lineNotes[n4] + 12 != n && this.lineNotes[n4] + 36 != n && this.lineNotes[n4] + 60 != n && this.lineNotes[n4] + 84 != n && this.lineNotes[n4] + 108 != n && n != Integer.MIN_VALUE) continue;
                this.displayImage(this.g, this.dot, this.totalBeatWidth + 1, n2 - 4);
                n5 = 0;
                n4 = this.lineNotes.length;
            }
            if (n5 != 0) {
                this.displayImage(this.g, this.dot, this.totalBeatWidth + 1, n2);
            }
        }
        if (n == 60 || n == 61 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 52, this.totalBeatWidth + 12, this.bPos + 52);
        }
        if (n <= 40 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 100, this.totalBeatWidth + 12, this.bPos + 100);
        }
        if (n <= 37 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 108, this.totalBeatWidth + 12, this.bPos + 108);
        }
        if (n <= 16 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 156, this.totalBeatWidth + 12, this.bPos + 156);
        }
        if (n <= 13 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 164, this.totalBeatWidth + 12, this.bPos + 164);
        }
        if (n <= 10 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 172, this.totalBeatWidth + 12, this.bPos + 172);
        }
        if (n <= 6 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 180, this.totalBeatWidth + 12, this.bPos + 180);
        }
        if (n <= 3 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 188, this.totalBeatWidth + 12, this.bPos + 188);
        }
        if (n >= 81 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 4, this.totalBeatWidth + 12, this.bPos + 4);
        }
        if (n >= 84 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 4, this.totalBeatWidth + 12, this.bPos - 4);
        }
        if (n >= 105 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 52, this.totalBeatWidth + 12, this.bPos - 52);
        }
        if (n >= 108 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 60, this.totalBeatWidth + 12, this.bPos - 60);
        }
        if (n >= 112 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 68, this.totalBeatWidth + 12, this.bPos - 68);
        }
        if (n >= 115 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 76, this.totalBeatWidth + 12, this.bPos - 76);
        }
        if (n >= 119 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 84, this.totalBeatWidth + 12, this.bPos - 84);
        }
        if (n >= 122 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 92, this.totalBeatWidth + 12, this.bPos - 92);
        }
        if (n >= 125 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 100, this.totalBeatWidth + 12, this.bPos - 100);
        }
        this.savedBeatWidth2 = this.totalBeatWidth;
        if ((this.isTied || this.extraImagesUsed) && this.isNote && !this.isFirstNoteInTie) {
            Image image = this.tie.image;
            if (!this.isNormalColor) {
                image = this.tie.redImage;
            }
            n4 = n2 + 19 - (this.semitoneShiftUp ? 4 : 0);
            if (this.isUp) {
                this.g.drawImage(image, this.savedBeatWidth - 3 + 9, n4 + 17 + image.getHeight(this), this.savedBeatWidth2 + 19 - 9, n4 + 17, 0, 0, image.getWidth(this), image.getHeight(this), this);
            } else {
                this.g.drawImage(image, this.savedBeatWidth - 3 + 9, n4 - 20, this.savedBeatWidth2 + 19 - 9, n4 - 20 + image.getHeight(this), 0, 0, image.getWidth(this), image.getHeight(this), this);
            }
        }
        this.isFirstNoteInTie = true;
        if (true) {
            this.isFirstNoteInTie = false;
        }
        this.savedBeatWidth = this.totalBeatWidth;
        this.totalBeatWidth += this.currBeatWidth;
        this.dottedNote = false;
        this.beatCounter += (double)((int)(d / 0.25)) * 0.25;
        if (this.metre != 0.0 && this.beatCounter % this.metre == 0.0) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + 12 - this.staveSpaceHeight * 7, this.totalBeatWidth, this.bPos + 44 + this.staveSpaceHeight * 13);
            if (this.barNumbers) {
                this.g.drawString("" + (int)(this.beatCounter / this.metre + 1.0), this.totalBeatWidth - 4, this.bPos - 50);
            }
            this.totalBeatWidth += 12;
        }
    }

    public void displayImage(Graphics graphics, RedFilter redFilter, int n, int n2) {
        if (this.isNormalColor) {
            graphics.drawImage(redFilter.image, n, n2, this);
        } else {
            graphics.drawImage(redFilter.redImage, n, n2, this);
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(2000, 500);
    }

    public void setPhrase(Phrase phrase) {
        this.phrase = phrase;
        this.previouslyChromatic.removeAllElements();
        this.setTitle(phrase.getTitle());
        this.repaint();
    }

    public Phrase getPhrase() {
        return this.phrase;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void removeTitle() {
        this.title = null;
    }

    public void setMetre(double d) {
        this.metre = d;
    }

    public double getMetre() {
        return this.metre;
    }

    public void setScale(int[] nArray) {
        this.scale = nArray;
        this.setTonic(this.tonic);
    }

    public int getTonic() {
        return this.tonic;
    }

    public void setKey(int n, int[] nArray) {
        this.scale = nArray;
        this.setTonic(n);
    }

    public void setTonic(int n) {
        if (n < 0 || n > 11) {
            return;
        }
        if (this.scale == JMC.MAJOR_SCALE) {
            this.tonic = n;
        } else if (this.scale == JMC.NATURAL_MINOR_SCALE) {
            this.tonic = n;
            n = (n + 3) % 12;
        } else {
            return;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] != n) continue;
            this.keySignature = i - 7;
        }
        this.repaint();
        if (this.keyChangeListener == null) {
            return;
        }
        this.keyChangeListener.keyChanged();
    }

    public void setKeyChangeListener(KeyChangeListener keyChangeListener) {
        this.keyChangeListener = keyChangeListener;
    }

    public void setKeySignature(int n) {
        int n2 = n > 7 ? 7 : (this.keySignature = n < -7 ? -7 : n);
        if (this.keyChangeListener == null) {
            return;
        }
        this.keyChangeListener.keyChanged();
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setBarNumbers(boolean bl) {
        this.barNumbers = bl;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public int getMinPitch() {
        return this.minPitch;
    }

    public void setMinPitch(int n) {
        this.minPitch = n;
    }

    public int getMaxPitch() {
        return this.maxPitch;
    }

    public void setMaxPitch(int n) {
        this.maxPitch = n;
    }

    public int getTotalBeatWidth() {
        return this.totalBeatWidth;
    }

    public void setTotalBeatWidth(int n) {
        this.totalBeatWidth = n;
    }

    public boolean getBarNumbers() {
        return this.barNumbers;
    }

    public boolean getQtOn() {
        return this.qtOn;
    }

    public void setQtOn(boolean bl) {
        this.qtOn = bl;
    }

    public void updateChange() {
    }

    public void deleteLastNote() {
        if (this.phrase.size() > 0) {
            this.phrase.removeNote(this.phrase.size() - 1);
            this.repaint();
            this.updateChange();
        }
    }

    protected void chooseImage(int n, double d, int n2, int n3, int n4) {
        if (n == Integer.MIN_VALUE) {
            this.isNote = false;
            if (d <= 0.0) {
                this.currImage = this.delete;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            }
            if (d > 0.0 && d <= 0.25) {
                this.currImage = this.semiquaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            }
            if (d > 0.25 && d <= 0.5) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
            }
            if (d > 0.5 && d <= 0.75) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                this.dottedNote = true;
            }
            if (d > 0.75 && d <= 1.0) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
            }
            if (d > 1.0 && d <= 1.25) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = d - 1.0;
            }
            if (d > 1.25 && d <= 1.5) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
            }
            if (d > 1.5 && d <= 1.75) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = d - 1.5;
            }
            if (d > 1.75 && d <= 2.0) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
            }
            if (d > 2.0 && d <= 2.75) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = d - 2.0;
            }
            if (d > 2.75 && d <= 3.0) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
            }
            if (d > 3.0 && d <= 3.75) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = d - 3.0;
            }
            if (d > 3.75 && d <= 4.0) {
                this.currImage = this.semibreveRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            }
        } else {
            this.isNote = true;
            if (n < n2 && n >= n3 || n < n4) {
                if (d <= 0.0) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                    this.isUp = true;
                }
                if (d > 0.0 && d <= 0.25) {
                    this.currImage = this.semiquaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                    this.isUp = true;
                }
                if (d > 0.25 && d <= 0.5) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.isUp = true;
                }
                if (d > 0.5 && d <= 0.75) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.dottedNote = true;
                    this.isUp = true;
                }
                if (d > 0.75 && d <= 1.0) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                    this.isUp = true;
                }
                if (d > 1.0 && d <= 1.25) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 1.0;
                    this.isUp = true;
                }
                if (d > 1.25 && d <= 1.5) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.isUp = true;
                }
                if (d > 1.5 && d <= 1.75) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 1.5;
                    this.isUp = true;
                }
                if (d > 1.75 && d <= 2.0) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.isUp = true;
                }
                if (d > 2.0 && d <= 2.75) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 2.0;
                    this.isUp = true;
                }
                if (d > 2.75 && d <= 3.0) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.isUp = true;
                }
                if (d > 3.0 && d <= 3.75) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 3.0;
                    this.isUp = true;
                }
                if (d > 3.75 && d <= 4.0) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.isUp = true;
                }
            } else {
                if (d <= 0.0) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                    this.isUp = false;
                }
                if (d > 0.0 && d <= 0.25) {
                    this.currImage = this.semiquaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                    this.isUp = false;
                }
                if (d > 0.25 && d <= 0.5) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.isUp = false;
                }
                if (d > 0.5 && d <= 0.75) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.dottedNote = true;
                    this.isUp = false;
                }
                if (d > 0.75 && d <= 1.0) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                    this.isUp = false;
                }
                if (d > 1.0 && d <= 1.25) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 1.0;
                    this.isUp = false;
                }
                if (d > 1.25 && d <= 1.5) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.isUp = false;
                }
                if (d > 1.5 && d <= 1.75) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 1.5;
                    this.isUp = false;
                }
                if (d > 1.75 && d <= 2.0) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.isUp = false;
                }
                if (d > 2.0 && d <= 2.75) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 2.0;
                    this.isUp = false;
                }
                if (d > 2.75 && d <= 3.0) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.isUp = false;
                }
                if (d > 3.0 && d <= 3.75) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 3.0;
                    this.isUp = false;
                }
                if (d > 3.75 && d <= 4.0) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.isUp = false;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class RedFilter {
        public Image image;
        public Image redImage;

        RedFilter() {
        }

        RedFilter(Image image) {
            this.image = image;
            this.redImage = JGrandStave.this.createImage(new FilteredImageSource(image.getSource(), JGrandStave.this.filter));
        }
    }
}

