/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.ScrollPane;
import java.awt.TextArea;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import jm.gui.cpn.Stave;
import jm.music.data.Note;
import jm.music.data.Phrase;

public class PhraseViewer
extends Dialog
implements WindowListener {
    private ScrollPane scrollPane = new ScrollPane();
    private TextArea textArea = new TextArea(20, 120);
    private Phrase phrase;
    private Stave stave;
    private DecimalFormat decimalFormat = new DecimalFormat("#####.######");

    public PhraseViewer(Frame frame) {
        super(frame, "Phrase Detail Display", true);
        this.setSize(500, 400);
        this.placeControls();
        this.addWindowListener(this);
        this.setVisible(false);
        this.pack();
    }

    private void placeControls() {
        this.scrollPane.add(this.textArea);
        this.setLayout(new BorderLayout());
        this.add("Center", this.scrollPane);
    }

    public void showPhrase(Stave stave, Phrase phrase, int n, int n2) {
        this.stave = stave;
        this.phrase = phrase;
        this.getPhraseText();
        this.setLocation(n, n2);
        this.show();
    }

    private void getPhraseText() {
        this.getStaveText();
        this.textArea.append("Phrase has " + this.phrase.size() + " notes.\n");
        this.textArea.append("Tempo " + this.decimalFormat.format(this.phrase.getTempo()));
        this.textArea.append("    Numerator " + this.phrase.getNumerator());
        this.textArea.append("    Denominator " + this.phrase.getDenominator());
        this.textArea.append("\n");
        for (int i = 0; i < this.phrase.size(); ++i) {
            this.getNoteText(this.phrase.getNote(i));
        }
    }

    private void getStaveText() {
        this.textArea.append("Stave " + this.stave.getTitle() + "   Metre " + this.decimalFormat.format(this.stave.getMetre()) + "\n");
    }

    private void getNoteText(Note note) {
        this.textArea.append("Pitch " + note.getPitch());
        this.textArea.append("   Start " + this.decimalFormat.format(note.getSampleStartTime()));
        this.textArea.append("   Rhythm " + this.decimalFormat.format(note.getRhythmValue()));
        this.textArea.append("   Dur " + this.decimalFormat.format(note.getDuration()));
        this.textArea.append("   Offset " + this.decimalFormat.format(note.getOffset()));
        this.textArea.append("   Vol " + note.getDynamic());
        this.textArea.append("\n");
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getSource() == this) {
            this.dispose();
        }
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

