/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import jm.JMC;
import jm.gui.cpn.Images;
import jm.gui.cpn.StaveActionHandler;
import jm.gui.cpn.ToolkitImages;
import jm.music.data.Phrase;
import jm.music.tools.Mod;

public abstract class Stave
extends Panel
implements JMC,
KeyListener {
    protected boolean requiresMoreThanOneImage = false;
    protected double excessRhythmValue = 0.0;
    protected boolean isUp = true;
    protected boolean isNote = false;
    public Image image;
    protected Graphics g;
    protected Image trebleClef;
    protected Image bassClef;
    protected Image crotchetUp;
    protected Image crotchetDown;
    protected Image quaverDown;
    protected Image quaverUp;
    protected Image semiquaverDown;
    protected Image semiquaverUp;
    protected Image minimDown;
    protected Image minimUp;
    protected Image semibreve;
    protected Image dot;
    protected Image semiquaverRest;
    protected Image quaverRest;
    protected Image crotchetRest;
    protected Image minimRest;
    protected Image semibreveRest;
    protected Image sharp;
    protected Image flat;
    protected Image natural;
    protected Image one;
    protected Image two;
    protected Image three;
    protected Image four;
    protected Image five;
    protected Image six;
    protected Image seven;
    protected Image eight;
    protected Image nine;
    protected Image delete;
    protected Image tieOver;
    protected Image tieUnder;
    public int staveSpaceHeight = 8;
    public int rightMargin = 20;
    public int beatWidth = 43;
    public int staveWidth = this.beatWidth * 15;
    public int imageHeightOffset = 28;
    public int clefWidth = 38;
    public int timeSigWidth = 5;
    public int keySigWidth = 5;
    public int bPos = 28;
    protected Phrase phrase;
    protected Image currImage;
    protected int currBeatWidth;
    protected int totalBeatWidth;
    protected boolean dottedNote = false;
    protected int[] notePosOffset = new int[]{24, 24, 20, 20, 16, 12, 12, 8, 8, 4, 4, 0};
    protected double metre = 4.0;
    protected int keySignature = 0;
    protected int[] sharps = new int[]{77, 72, 79, 74, 69, 76, 71};
    protected int[] flats = new int[]{71, 76, 69, 74, 67, 72, 65};
    protected Vector previouslyChromatic = new Vector();
    protected int[] lineNotes = new int[]{0, 1, 4, 7, 8, 11, 14, 15, 17, 18, 21, 22};
    public Vector notePositions = new Vector();
    protected int maxPitch = 127;
    protected int minPitch = 0;
    protected String title;
    protected boolean barNumbers = false;
    protected boolean editable = true;
    protected boolean qtOn = false;
    protected int panelHeight = 110;
    protected int staveDelta = 0;
    protected boolean displayTitle = false;
    protected Font font = new Font("Helvetica", 0, 10);
    protected int spacingValue = 70;

    public Stave() {
        this(new Phrase(), new ToolkitImages());
    }

    public Stave(Phrase phrase) {
        this(phrase, new ToolkitImages());
    }

    public Stave(Images images) {
        this(new Phrase(), images);
    }

    public Stave(Phrase phrase, Images images) {
        this.title = phrase.getTitle();
        this.phrase = this.addRequiredRests(phrase);
        this.setBackground(Color.getHSBColor(0.14f, 0.09f, 1.0f));
        this.setSize(this.beatWidth * this.spacingValue, this.panelHeight);
        if (this.getSize().width < (int)(this.phrase.getEndTime() * (double)this.beatWidth * 1.5)) {
            this.setSize((int)(this.phrase.getEndTime() * (double)this.beatWidth * 1.5), this.panelHeight);
        }
        StaveActionHandler staveActionHandler = new StaveActionHandler(this);
        this.addMouseListener(staveActionHandler);
        this.addMouseMotionListener(staveActionHandler);
        this.trebleClef = images.getTrebleClef();
        this.bassClef = images.getBassClef();
        this.crotchetDown = images.getCrotchetDown();
        this.crotchetUp = images.getCrotchetUp();
        this.quaverDown = images.getQuaverDown();
        this.quaverUp = images.getQuaverUp();
        this.semiquaverDown = images.getSemiquaverDown();
        this.semiquaverUp = images.getSemiquaverUp();
        this.minimDown = images.getMinimDown();
        this.minimUp = images.getMinimUp();
        this.semibreve = images.getSemibreve();
        this.dot = images.getDot();
        this.semiquaverRest = images.getSemiquaverRest();
        this.quaverRest = images.getQuaverRest();
        this.crotchetRest = images.getCrotchetRest();
        this.minimRest = images.getMinimRest();
        this.semibreveRest = images.getSemibreveRest();
        this.sharp = images.getSharp();
        this.flat = images.getFlat();
        this.natural = images.getNatural();
        this.one = images.getOne();
        this.two = images.getTwo();
        this.three = images.getThree();
        this.four = images.getFour();
        this.five = images.getFive();
        this.six = images.getSix();
        this.seven = images.getSeven();
        this.eight = images.getEight();
        this.nine = images.getNine();
        this.delete = images.getDelete();
        this.tieOver = images.getTieOver();
        this.tieUnder = images.getTieUnder();
    }

    public Phrase addRequiredRests(Phrase phrase) {
        if (phrase.getStartTime() > 0.0) {
            double d;
            Phrase phrase2 = new Phrase(0.0);
            for (d = phrase.getStartTime(); d >= 4.0; d -= 4.0) {
                phrase2.addNote(Integer.MIN_VALUE, 4.0);
            }
            while (d >= 1.0) {
                phrase2.addNote(Integer.MIN_VALUE, 1.0);
                d -= 1.0;
            }
            phrase2.addNote(Integer.MIN_VALUE, d);
            Mod.append(phrase2, phrase);
            phrase = phrase2;
        }
        return phrase;
    }

    public void setPhrase(Phrase phrase) {
        this.phrase = this.addRequiredRests(phrase);
        this.previouslyChromatic.removeAllElements();
        this.repaint();
    }

    public Phrase getPhrase() {
        return this.phrase;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.phrase != null) {
            this.phrase.setTitle(string);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void removeTitle() {
        this.title = null;
    }

    public void setDisplayTitle(boolean bl) {
        this.displayTitle = bl;
        this.repaint();
    }

    public boolean getDisplayTitle() {
        return this.displayTitle;
    }

    public int getPanelHeight() {
        return this.panelHeight;
    }

    public void setMetre(double d) {
        this.metre = d;
    }

    public double getMetre() {
        return this.metre;
    }

    public int getMajorKey() {
        int[] nArray = new int[]{11, 6, 1, 8, 3, 10, 5, 0, 7, 2, 9, 4, 11, 6, 1};
        return nArray[this.keySignature + 7];
    }

    public void setKeySignature(int n) {
        this.keySignature = n;
    }

    public int getKeySignature() {
        return this.keySignature;
    }

    public void setBarNumbers(boolean bl) {
        this.barNumbers = bl;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public int getMinPitch() {
        return this.minPitch;
    }

    public void setMinPitch(int n) {
        this.minPitch = n;
    }

    public int getMaxPitch() {
        return this.maxPitch;
    }

    public void setMaxPitch(int n) {
        this.maxPitch = n;
    }

    public int getTotalBeatWidth() {
        return this.totalBeatWidth;
    }

    public void setTotalBeatWidth(int n) {
        this.totalBeatWidth = n;
    }

    public boolean getBarNumbers() {
        return this.barNumbers;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, this.getSize().height);
    }

    public boolean getQtOn() {
        return this.qtOn;
    }

    public void setQtOn(boolean bl) {
        this.qtOn = bl;
    }

    public void updateChange() {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
    }

    public void deleteLastNote() {
        if (this.phrase.size() > 0) {
            this.phrase.removeNote(this.phrase.size() - 1);
            this.repaint();
            this.updateChange();
        }
    }

    protected void chooseImage(int n, double d, int n2, int n3, int n4) {
        if (n == Integer.MIN_VALUE) {
            this.isNote = false;
            if (d <= 0.0) {
                this.currImage = this.delete;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            } else if (d <= 0.2501) {
                this.currImage = this.semiquaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            } else if (d <= 0.501) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
            } else if (d <= 0.7501) {
                this.currImage = this.quaverRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                this.dottedNote = true;
            } else if (d <= 1.001) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
            } else if (d <= 1.2501) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = this.beatWidth;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = d - 1.0;
            } else if (d <= 1.501) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
            } else if (d <= 1.7501) {
                this.currImage = this.crotchetRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = d - 1.5;
            } else if (d <= 2.001) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
            } else if (d <= 2.7501) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = d - 2.0;
            } else if (d <= 3.001) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
            } else if (d <= 3.7501) {
                this.currImage = this.minimRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                this.dottedNote = true;
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = d - 3.0;
            } else if (d <= 4.001) {
                this.currImage = this.semibreveRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
            } else {
                this.currImage = this.semibreveRest;
                this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                this.requiresMoreThanOneImage = true;
                this.excessRhythmValue = d - 4.0;
            }
        } else {
            this.isNote = true;
            if (n < n2 && n >= n3 || n < n4) {
                this.isUp = true;
                if (d <= 0.001) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (d <= 0.2501) {
                    this.currImage = this.semiquaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (d <= 0.501) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                } else if (d <= 0.7501) {
                    this.currImage = this.quaverUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.67);
                    this.dottedNote = true;
                } else if (d <= 1.001) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                } else if (d <= 1.2501) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 1.0;
                } else if (d <= 1.501) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                } else if (d <= 1.7501) {
                    this.currImage = this.crotchetUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 1.5;
                } else if (d <= 2.001) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                } else if (d <= 2.7501) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 2.0;
                } else if (d <= 3.001) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                } else if (d <= 3.7501) {
                    this.currImage = this.minimUp;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 3.0;
                } else if (d <= 4.001) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                } else {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 4.0;
                }
            } else {
                this.isUp = false;
                if (d <= 0.001) {
                    this.currImage = this.delete;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (d <= 0.2501) {
                    this.currImage = this.semiquaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.5);
                } else if (d <= 0.501) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                } else if (d <= 0.7501) {
                    this.currImage = this.quaverDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 0.6666666666666666);
                    this.dottedNote = true;
                } else if (d <= 1.001) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                } else if (d <= 1.2501) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = this.beatWidth;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 1.0;
                } else if (d <= 1.501) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                } else if (d <= 1.7501) {
                    this.currImage = this.crotchetDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.5);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 1.5;
                } else if (d <= 2.001) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                } else if (d <= 2.7501) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.7);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 2.0;
                } else if (d <= 3.001) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                } else if (d <= 3.7501) {
                    this.currImage = this.minimDown;
                    this.currBeatWidth = (int)((double)this.beatWidth * 1.9);
                    this.dottedNote = true;
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 3.0;
                } else if (d <= 4.001) {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                } else {
                    this.currImage = this.semibreve;
                    this.currBeatWidth = (int)((double)this.beatWidth * 2.25);
                    this.requiresMoreThanOneImage = true;
                    this.excessRhythmValue = d - 4.0;
                }
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        System.out.println(keyEvent.getKeyChar());
    }
}

