/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jm.JMC;
import jm.gui.cpn.NoteEditor;
import jm.gui.cpn.Stave;
import jm.music.data.Note;
import jm.music.data.Phrase;

public class StaveActionHandler
implements JMC,
MouseListener,
MouseMotionListener,
ActionListener,
KeyListener {
    private Stave theApp;
    private int selectedNote = -1;
    private boolean topTimeSelected = false;
    private boolean keySelected = false;
    private int clickedPosY;
    private int clickedPosX;
    private int storedPitch = 72;
    private double[] rhythmValues = new double[]{104.0, 103.0, 102.0, 101.5, 101.0, 100.75, 100.5, 100.25, 0.0, 0.25, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0};
    private boolean button1Down = false;
    private PopupMenu noteContextMenu;
    private MenuItem editNote;
    private MenuItem repeatNote;
    private MenuItem makeRest;
    private MenuItem deleteNote;

    StaveActionHandler(Stave stave) {
        this.theApp = stave;
        this.noteContextMenu = new PopupMenu();
        this.editNote = new MenuItem("Edit Note");
        this.editNote.addActionListener(this);
        this.noteContextMenu.add(this.editNote);
        this.repeatNote = new MenuItem("Repeat Note");
        this.repeatNote.addActionListener(this);
        this.noteContextMenu.add(this.repeatNote);
        this.makeRest = new MenuItem("Change to Rest");
        this.makeRest.addActionListener(this);
        this.noteContextMenu.add(this.makeRest);
        this.deleteNote = new MenuItem("Delete Note");
        this.deleteNote.addActionListener(this);
        this.noteContextMenu.add(this.deleteNote);
        this.theApp.add(this.noteContextMenu);
    }

    boolean inNoteArea(MouseEvent mouseEvent) {
        Integer n = this.theApp.notePositions.size() < 2 ? new Integer(this.theApp.getTotalBeatWidth()) : (Integer)this.theApp.notePositions.elementAt(this.theApp.notePositions.size() - 2);
        return mouseEvent.getX() <= n + 15 && mouseEvent.getX() < this.theApp.getTotalBeatWidth() + 50;
    }

    private void searchForSelectedNote(MouseEvent mouseEvent) {
        for (int i = 0; i < this.theApp.notePositions.size(); i += 2) {
            Integer n = (Integer)this.theApp.notePositions.elementAt(i);
            Integer n2 = (Integer)this.theApp.notePositions.elementAt(i + 1);
            if (mouseEvent.getX() <= n || mouseEvent.getX() >= n + 15 || mouseEvent.getY() + this.theApp.staveDelta <= n2 + 22 || mouseEvent.getY() + this.theApp.staveDelta >= n2 + 35) continue;
            this.selectedNote = i / 2;
            this.clickedPosY = mouseEvent.getY() + this.theApp.staveDelta;
            this.clickedPosX = mouseEvent.getX();
            i = this.theApp.notePositions.size();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 8) != 0 && this.inNoteArea(mouseEvent)) {
            this.searchForSelectedNote(mouseEvent);
            if (this.selectedNote >= 0 && this.selectedNote < this.theApp.getPhrase().size()) {
                this.noteContextMenu.show(this.theApp, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        int n;
        Object object2;
        int n2;
        if (mouseEvent.isPopupTrigger() || (mouseEvent.getModifiers() & 8) != 0 || !this.theApp.editable) {
            return;
        }
        this.button1Down = true;
        if (!this.inNoteArea(mouseEvent)) {
            n2 = 85 - (mouseEvent.getY() + this.theApp.staveDelta - this.theApp.bPos) / 2;
            object2 = new int[]{1, 3, 6, 8, 10};
            n = 1;
            for (int i = 0; i < ((Object)object2).length; ++i) {
                if (n2 % 12 != object2[i]) continue;
                --n2;
            }
            Note note = new Note(n2, 1.0);
            object = this.theApp.getPhrase();
            ((Phrase)object).addNote(note);
            this.theApp.repaint();
            this.theApp.setCursor(new Cursor(12));
            this.selectedNote = ((Phrase)object).size() - 1;
            this.clickedPosY = mouseEvent.getY() + this.theApp.staveDelta;
            this.clickedPosX = mouseEvent.getX();
        } else {
            this.searchForSelectedNote(mouseEvent);
            this.theApp.setCursor(new Cursor(13));
        }
        if (this.selectedNote < 0) {
            for (n2 = 0; n2 < this.theApp.notePositions.size() - 2; n2 += 2) {
                object2 = (Integer)this.theApp.notePositions.elementAt(n2);
                Integer n3 = (Integer)this.theApp.notePositions.elementAt(n2 + 2);
                if (mouseEvent.getX() <= (Integer)object2 + 15 || mouseEvent.getX() >= n3) continue;
                this.theApp.setCursor(new Cursor(12));
                int n4 = 85 - (mouseEvent.getY() + this.theApp.staveDelta - this.theApp.bPos) / 2;
                object = new int[]{1, 3, 6, 8, 10};
                boolean bl = true;
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (n4 % 12 != object[i]) continue;
                    --n4;
                }
                Note note = new Note(n4, 1.0);
                Phrase phrase = this.theApp.getPhrase();
                phrase.getNoteList().insertElementAt(note, n2 / 2 + 1);
                this.theApp.repaint();
                this.selectedNote = n2 / 2 + 1;
                this.clickedPosY = mouseEvent.getY() + this.theApp.staveDelta;
                this.clickedPosX = mouseEvent.getX();
                n2 = this.theApp.notePositions.size();
            }
        }
        n2 = this.theApp.rightMargin + this.theApp.clefWidth + this.theApp.keySigWidth;
        if (mouseEvent.getX() > n2 && mouseEvent.getX() < n2 + 10) {
            this.theApp.setCursor(new Cursor(13));
            this.topTimeSelected = true;
            this.clickedPosY = mouseEvent.getY() + this.theApp.staveDelta;
            this.clickedPosX = mouseEvent.getX();
        }
        int n5 = this.theApp.rightMargin + this.theApp.clefWidth;
        n = 10;
        if (this.theApp.keySigWidth > n) {
            n = this.theApp.keySigWidth;
        }
        if (mouseEvent.getX() > n5 - 10 && mouseEvent.getX() < n5 + n) {
            this.theApp.setCursor(new Cursor(13));
            this.keySelected = true;
            this.clickedPosY = mouseEvent.getY() + this.theApp.staveDelta;
            this.clickedPosX = mouseEvent.getX();
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.button1Down || !this.theApp.editable) {
            return;
        }
        if (this.selectedNote >= 0) {
            int n;
            int n2;
            int n3;
            double d;
            Phrase phrase = this.theApp.getPhrase();
            Note note = phrase.getNote(this.selectedNote);
            if (mouseEvent.getY() + this.theApp.staveDelta > this.clickedPosY + 2 && this.theApp.getPhrase().getNote(this.selectedNote).getPitch() != Integer.MIN_VALUE) {
                note.setPitch(note.getPitch() - 1);
                if (note.getPitch() < this.theApp.getMinPitch()) {
                    note.setPitch(this.theApp.getMinPitch());
                }
                this.clickedPosY += 2;
                this.theApp.repaint();
                this.storedPitch = note.getPitch();
            }
            if (mouseEvent.getY() + this.theApp.staveDelta < this.clickedPosY - 2 && this.theApp.getPhrase().getNote(this.selectedNote).getPitch() != Integer.MIN_VALUE) {
                note.setPitch(note.getPitch() + 1);
                if (note.getPitch() > this.theApp.getMaxPitch()) {
                    note.setPitch(this.theApp.getMaxPitch());
                }
                this.clickedPosY -= 2;
                this.theApp.repaint();
                this.storedPitch = note.getPitch();
            }
            if (mouseEvent.getX() > this.clickedPosX + 6) {
                d = note.getRhythmValue();
                n3 = note.getPitch();
                if (n3 == Integer.MIN_VALUE) {
                    d += 100.0;
                }
                n2 = this.rhythmValues.length;
                for (n = 0; n < this.rhythmValues.length - 1; ++n) {
                    if (d != this.rhythmValues[n]) continue;
                    note.setRhythmValue(this.rhythmValues[n + 1]);
                }
                this.clickedPosX = mouseEvent.getX();
                if (note.getRhythmValue() > 100.0) {
                    note.setPitch(Integer.MIN_VALUE);
                    note.setRhythmValue(note.getRhythmValue() - 100.0);
                    note.setDuration(note.getRhythmValue() * 0.9);
                } else if (n3 == Integer.MIN_VALUE) {
                    note.setPitch(this.storedPitch);
                }
                this.theApp.repaint();
            }
            if (mouseEvent.getX() < this.clickedPosX - 6) {
                d = note.getRhythmValue();
                n3 = note.getPitch();
                if (n3 == Integer.MIN_VALUE) {
                    d += 100.0;
                }
                n2 = 0;
                for (n = 0; n < this.rhythmValues.length; ++n) {
                    if (d != this.rhythmValues[n]) continue;
                    n2 = n;
                }
                if (n2 > 0) {
                    note.setRhythmValue(this.rhythmValues[n2 - 1]);
                    this.clickedPosX = mouseEvent.getX();
                    if (note.getRhythmValue() > 100.0) {
                        note.setPitch(Integer.MIN_VALUE);
                        note.setRhythmValue(note.getRhythmValue() - 100.0);
                        note.setDuration(note.getRhythmValue() * 0.9);
                    } else if (n3 == Integer.MIN_VALUE) {
                        note.setPitch(this.storedPitch);
                    }
                    this.theApp.repaint();
                }
            }
        }
        if (this.topTimeSelected) {
            if (mouseEvent.getY() + this.theApp.staveDelta < this.clickedPosY - 4) {
                this.theApp.setMetre(this.theApp.getMetre() + 1.0);
                if (this.theApp.getMetre() > 9.0) {
                    this.theApp.setMetre(9.0);
                }
                if (this.theApp.getMetre() < 1.0) {
                    this.theApp.setMetre(1.0);
                }
                this.theApp.getPhrase().setNumerator(new Double(Math.round(this.theApp.getMetre())).intValue());
                this.clickedPosY -= 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
            if (mouseEvent.getY() + this.theApp.staveDelta > this.clickedPosY + 4) {
                this.theApp.setMetre(this.theApp.getMetre() - 1.0);
                if (this.theApp.getMetre() < 1.0) {
                    this.theApp.setMetre(1.0);
                }
                if (this.theApp.getMetre() > 9.0) {
                    this.theApp.setMetre(9.0);
                }
                this.theApp.getPhrase().setNumerator(new Double(Math.round(this.theApp.getMetre())).intValue());
                this.clickedPosY += 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
        }
        if (this.keySelected) {
            if (mouseEvent.getY() + this.theApp.staveDelta < this.clickedPosY - 4) {
                this.theApp.setKeySignature(this.theApp.getKeySignature() + 1);
                if (this.theApp.getKeySignature() > 7) {
                    this.theApp.setKeySignature(7);
                }
                this.clickedPosY -= 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
            if (mouseEvent.getY() + this.theApp.staveDelta > this.clickedPosY + 4) {
                this.theApp.setKeySignature(this.theApp.getKeySignature() - 1);
                if (this.theApp.getKeySignature() < -7) {
                    this.theApp.setKeySignature(-7);
                }
                this.clickedPosY += 4;
                this.theApp.repaint();
                this.theApp.updateChange();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.button1Down = false;
        if (!this.theApp.editable) {
            return;
        }
        for (int i = 0; i < this.theApp.getPhrase().getNoteList().size(); ++i) {
            if (this.theApp.getPhrase().getNote(i).getRhythmValue() != 0.0) continue;
            this.theApp.getPhrase().getNoteList().removeElementAt(i);
        }
        this.theApp.repaint();
        this.theApp.updateChange();
        this.selectedNote = -1;
        this.topTimeSelected = false;
        this.keySelected = false;
        this.theApp.setCursor(new Cursor(0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Phrase phrase = this.theApp.getPhrase();
        Note note = phrase.getNote(this.selectedNote);
        if (actionEvent.getSource() == this.editNote) {
            Frame frame = new Frame("Edit this Note");
            frame.setSize(400, 400);
            frame.setResizable(true);
            NoteEditor noteEditor = new NoteEditor(frame);
            noteEditor.editNote(note, 20, 20);
        } else if (actionEvent.getSource() == this.repeatNote) {
            Note note2 = note.copy();
            phrase.getNoteList().insertElementAt(note2, this.selectedNote);
        } else if (actionEvent.getSource() == this.makeRest) {
            note.setFrequency(-2.147483648E9);
        } else if (actionEvent.getSource() == this.deleteNote) {
            phrase.getNoteList().removeElementAt(this.selectedNote);
        }
        this.selectedNote = -1;
        this.theApp.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\b') {
            this.theApp.deleteLastNote();
        }
    }
}

