/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import jm.gui.cpn.BassStave;
import jm.gui.cpn.GrandStave;
import jm.gui.cpn.PianoStave;
import jm.gui.cpn.Stave;
import jm.gui.cpn.TrebleStave;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;

public class StavePhraseProperties
extends Properties {
    private static String KEY_SIGNATURE = "STAVE_KEY";
    private static String STAVE_TYPE = "STAVE_TYPE";
    private static String STAVE_TITLE = "STAVE_TITLE";
    private static String STAVE_METRE = "STAVE_METRE";
    private static String PHRASE_NUMERATOR = "PHRASE_NUM";
    private static String PHRASE_DENOMINATOR = "PHRASE_DEN";
    private static String PHRASE_TEMPO = "PHRASE_TEMPO";
    private static String PHRASE_TITLE = "PHRASE_TITLE";
    private static String PHRASE_INSTRUMENT = "PHRASE_INSTRUMENT";
    private static String LAST_NOTE_RHYTHM = "LAST_NOTE_RHYTHM";
    private static String LAST_NOTE_DUR = "LAST_NOTE_DUR";
    private static String FINAL_REST_RHYTHM = "FINAL_REST_RHYTHM";
    private static String FINAL_REST_DUR = "FINAL_REST_DUR";
    private static String OTHER_NOTES_TOTAL_RHYTHM = "OTHER_NOTES_TOTAL_RHYTHM";
    private static String OTHER_NOTES_TOTAL_DUR = "OTHER_NOTES_TOTAL_DUR";
    private static String GRAND_STAVE = "GRAND_STAVE";
    private static String TREBLE_STAVE = "TREBLE_STAVE";
    private static String BASS_STAVE = "BASS_STAVE";
    private static String PIANO_STAVE = "PIANO_STAVE";
    private static String FILE_NAME_SUFFIX = "pj";

    public StavePhraseProperties(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string + FILE_NAME_SUFFIX);
        this.load(fileInputStream);
    }

    public StavePhraseProperties(Stave stave, Phrase phrase) {
        System.out.println("1");
        this.setSavedProperty(KEY_SIGNATURE, stave.getKeySignature());
        System.out.println("2");
        this.setSavedProperty(STAVE_TYPE, this.getStaveType(stave));
        System.out.println("3");
        this.setSavedProperty(STAVE_TITLE, stave.getTitle());
        System.out.println("4");
        this.setSavedProperty(STAVE_METRE, stave.getMetre());
        System.out.println("5");
        this.setSavedProperty(PHRASE_NUMERATOR, phrase.getNumerator());
        System.out.println("6");
        this.setSavedProperty(PHRASE_DENOMINATOR, phrase.getDenominator());
        System.out.println("7");
        this.setSavedProperty(PHRASE_INSTRUMENT, phrase.getInstrument());
        System.out.println("8");
        this.setSavedProperty(PHRASE_TEMPO, phrase.getTempo());
        System.out.println("9");
        this.setSavedProperty(PHRASE_TITLE, phrase.getTitle());
        int n = StavePhraseProperties.findLastNonRest(phrase);
        System.out.println("10");
        if (n >= 0) {
            this.setSavedProperty(LAST_NOTE_RHYTHM, phrase.getNote(n).getRhythmValue());
            this.setSavedProperty(LAST_NOTE_DUR, phrase.getNote(n).getDuration());
        } else {
            this.setSavedProperty(LAST_NOTE_RHYTHM, 0.0);
            this.setSavedProperty(LAST_NOTE_DUR, 0.0);
        }
        this.setSavedProperty(FINAL_REST_RHYTHM, StavePhraseProperties.getFinalRestRhythm(phrase));
        this.setSavedProperty(FINAL_REST_DUR, StavePhraseProperties.getFinalRestDuration(phrase));
        this.setSavedProperty(OTHER_NOTES_TOTAL_RHYTHM, StavePhraseProperties.getOtherNotesTotalRhythm(phrase));
        this.setSavedProperty(OTHER_NOTES_TOTAL_DUR, StavePhraseProperties.getOtherNotesTotalDuration(phrase));
    }

    private void setSavedProperty(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        this.setProperty(string, string2);
    }

    private void setSavedProperty(String string, int n) {
        this.setSavedProperty(string, Integer.toString(n));
    }

    private void setSavedProperty(String string, double d) {
        this.setSavedProperty(string, Double.toString(d));
    }

    private String getStaveType(Stave stave) {
        if (stave instanceof TrebleStave) {
            return TREBLE_STAVE;
        }
        if (stave instanceof GrandStave) {
            return GRAND_STAVE;
        }
        if (stave instanceof BassStave) {
            return BASS_STAVE;
        }
        if (stave instanceof PianoStave) {
            return PIANO_STAVE;
        }
        return GRAND_STAVE;
    }

    public void writeToFile(String string) throws FileNotFoundException {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string + FILE_NAME_SUFFIX);
            this.save(fileOutputStream, "Stave and Phrase Properties for " + string);
        }
        catch (IOException iOException) {
            System.out.println("Error Writing MIDI Properties File " + string + " " + iOException.getMessage());
        }
    }

    public void updateStave(Stave stave) {
        stave.setKeySignature(new Integer(this.getProperty(KEY_SIGNATURE)));
        stave.setTitle(this.getProperty(STAVE_TITLE));
        stave.setMetre(new Double(this.getProperty(STAVE_METRE)));
    }

    public void updatePhrase(Phrase phrase) {
        phrase.setNumerator(new Integer(this.getProperty(PHRASE_NUMERATOR)));
        phrase.setDenominator(new Integer(this.getProperty(PHRASE_DENOMINATOR)));
        phrase.setTitle(this.getProperty(PHRASE_TITLE));
        phrase.setTempo(new Double(this.getProperty(PHRASE_TEMPO)));
        try {
            phrase.setInstrument(new Integer(this.getProperty(PHRASE_INSTRUMENT)));
        }
        catch (Throwable throwable) {
            phrase.setInstrument(0);
        }
        int n = StavePhraseProperties.findLastNonRest(phrase);
        if (n >= 0) {
            phrase.getNote(n).setRhythmValue(new Double(this.getProperty(LAST_NOTE_RHYTHM)));
            phrase.getNote(n).setDuration(new Double(this.getProperty(LAST_NOTE_DUR)));
        }
        Double d = new Double(this.getProperty(FINAL_REST_RHYTHM));
        if (d > 1.0E-5) {
            StavePhraseProperties.adjustFinalRestRhythm(phrase, new Double(this.getProperty(FINAL_REST_RHYTHM)), new Double(this.getProperty(FINAL_REST_DUR)));
        }
        StavePhraseProperties.adjustOtherNotesTotalRhythm(phrase, new Double(this.getProperty(OTHER_NOTES_TOTAL_RHYTHM)));
        StavePhraseProperties.adjustOtherNotesTotalDuration(phrase, new Double(this.getProperty(OTHER_NOTES_TOTAL_DUR)));
        Score score = new Score();
        Part part = new Part();
        score.addPart(part);
        part.addPhrase(phrase);
    }

    public boolean isTrebleStave() {
        return this.getProperty(STAVE_TYPE).equals(TREBLE_STAVE);
    }

    public boolean isBassStave() {
        return this.getProperty(STAVE_TYPE).equals(BASS_STAVE);
    }

    public boolean isGrandStave() {
        return this.getProperty(STAVE_TYPE).equals(GRAND_STAVE);
    }

    public boolean isPianoStave() {
        return this.getProperty(STAVE_TYPE).equals(PIANO_STAVE);
    }

    private static int findLastNonRest(Phrase phrase) {
        int n;
        for (n = phrase.size() - 1; n >= 0 && phrase.getNote(n).getPitch() == Integer.MIN_VALUE; --n) {
        }
        return n;
    }

    private static void adjustFinalRestRhythm(Phrase phrase, double d, double d2) {
        double d3 = StavePhraseProperties.getFinalRestRhythm(phrase);
        if (d - d3 > 0.001) {
            Note note = new Note();
            note.setFrequency(-2.147483648E9);
            note.setRhythmValue(d - d3);
            note.setDuration((d - d3) * (d2 / d));
            phrase.addNote(note);
        }
    }

    private static void adjustOtherNotesTotalRhythm(Phrase phrase, double d) {
        double d2 = StavePhraseProperties.getOtherNotesTotalRhythm(phrase);
        if (d2 > 0.0) {
            double d3 = d / d2;
            int n = StavePhraseProperties.findLastNonRest(phrase);
            for (int i = 0; i < n; ++i) {
                phrase.getNote(i).setRhythmValue(phrase.getNote(i).getRhythmValue() * d3);
            }
        }
    }

    private static void adjustOtherNotesTotalDuration(Phrase phrase, double d) {
        double d2 = StavePhraseProperties.getOtherNotesTotalDuration(phrase);
        if (d2 > 0.0) {
            double d3 = d / d2;
            int n = StavePhraseProperties.findLastNonRest(phrase);
            for (int i = 0; i < n; ++i) {
                if (phrase.getNote(i).getPitch() != Integer.MIN_VALUE) {
                    phrase.getNote(i).setDuration(phrase.getNote(i).getDuration() * d3);
                    continue;
                }
                phrase.getNote(i).setDuration(phrase.getNote(i).getRhythmValue());
            }
        }
    }

    private static double getFinalRestRhythm(Phrase phrase) {
        double d = 0.0;
        int n = phrase.size();
        for (int i = StavePhraseProperties.findLastNonRest(phrase) + 1; i < n; ++i) {
            d += phrase.getNote(i).getRhythmValue();
        }
        return d;
    }

    private static double getFinalRestDuration(Phrase phrase) {
        double d = 0.0;
        int n = phrase.size();
        for (int i = StavePhraseProperties.findLastNonRest(phrase) + 1; i < n; ++i) {
            d += phrase.getNote(i).getDuration();
        }
        return d;
    }

    private static double getOtherNotesTotalRhythm(Phrase phrase) {
        double d = 0.0;
        int n = StavePhraseProperties.findLastNonRest(phrase);
        for (int i = 0; i < n; ++i) {
            d += phrase.getNote(i).getRhythmValue();
        }
        return d;
    }

    private static double getOtherNotesTotalDuration(Phrase phrase) {
        double d = 0.0;
        int n = StavePhraseProperties.findLastNonRest(phrase);
        for (int i = 0; i < n; ++i) {
            if (phrase.getNote(i).getPitch() == Integer.MIN_VALUE) continue;
            d += phrase.getNote(i).getDuration();
        }
        return d;
    }
}

