/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.cpn;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.Vector;
import jm.JMC;
import jm.gui.cpn.Images;
import jm.gui.cpn.Stave;
import jm.music.data.Phrase;

public class TrebleStave
extends Stave
implements JMC {
    private Style style = new Style.JMusic();
    private int tonic = 0;
    protected int[] scale = JMC.MAJOR_SCALE;
    public static final int MAX_HEIGHT = 500;
    public static final int MAX_WIDTH = 2000;
    private double beatCounter;
    private boolean isFirstNoteInTie = true;
    private boolean firstAccidentalDisplayed = false;
    private boolean isTied = false;
    private boolean semitoneShiftUp = false;
    private boolean extraImagesUsed;
    private int savedBeatWidth;
    private int savedBeatWidth2;
    private int lastChordDisplayed = -1;
    private int lastPosition = 0;
    private String[] chordStrings = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "."};

    public void setAccidentalDisplayStyle(Style style) {
        if (style == Style.TRADITIONAL) {
            this.style = new Style.Trad();
        } else if (style == Style.JMUSIC) {
            this.style = new Style.JMusic();
        } else {
            throw new RuntimeException("Unknown Accidental Display Style");
        }
    }

    public TrebleStave() {
    }

    public TrebleStave(Phrase phrase) {
        super(phrase);
    }

    public TrebleStave(Images images) {
        super(images);
    }

    public TrebleStave(Phrase phrase, Images images) {
        super(phrase, images);
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        if (this.image == null) {
            this.image = this.createImage(2000, 500);
            this.g = this.image.getGraphics();
        }
        this.g.setFont(this.font);
        this.beatCounter = 0.0;
        this.notePositions.removeAllElements();
        if (this.getDisplayTitle()) {
            this.g.drawString(this.title, this.rightMargin, this.bPos - 10);
        }
        int n4 = 0;
        this.style.initialise(this.keySignature);
        if (this.keySignature > 0 && this.keySignature < 8) {
            for (n3 = 0; n3 < this.keySignature; ++n3) {
                n2 = this.notePosOffset[this.sharps[n3] % 12] + this.bPos - 4 + (5 - this.sharps[n3] / 12) * 24 + (6 - this.sharps[n3] / 12) * 4;
                this.g.drawImage(this.sharp, this.rightMargin + this.clefWidth + n4, n2, this);
                this.keySigWidth = n4 += 10;
            }
        } else if (this.keySignature < 0 && this.keySignature > -8) {
            for (n3 = 0; n3 < Math.abs(this.keySignature); ++n3) {
                n2 = this.notePosOffset[this.flats[n3] % 12] + this.bPos - 4 + (5 - this.flats[n3] / 12) * 24 + (6 - this.flats[n3] / 12) * 4;
                this.g.drawImage(this.flat, this.rightMargin + this.clefWidth + n4, n2, this);
                n4 += 10;
            }
        }
        this.keySigWidth = n4 + 3;
        if (this.metre != 0.0) {
            Image[] imageArray = new Image[]{this.one, this.two, this.three, this.four, this.five, this.six, this.seven, this.eight, this.nine};
            this.g.drawImage(imageArray[(int)this.metre - 1], this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 13, this);
            this.g.drawImage(this.four, this.rightMargin + this.clefWidth + this.keySigWidth, this.bPos + 29, this);
            this.timeSigWidth = 30;
        } else {
            this.timeSigWidth = 5;
        }
        this.totalBeatWidth = this.rightMargin + this.clefWidth + this.keySigWidth + this.timeSigWidth;
        this.lastChordDisplayed = -1;
        for (n = 0; n < this.phrase.size(); ++n) {
            double d;
            n2 = this.phrase.getNote(n).getPitch();
            int n5 = n2 == Integer.MIN_VALUE || this.phrase.getNote(n).getRhythmValue() == 0.0 ? this.notePosOffset[11] + this.bPos - 4 + 0 + 4 : this.notePosOffset[n2 % 12] + this.bPos - 4 + (5 - n2 / 12) * 24 + (6 - n2 / 12) * 4;
            this.firstAccidentalDisplayed = false;
            this.semitoneShiftUp = false;
            this.isTied = false;
            this.isFirstNoteInTie = true;
            this.extraImagesUsed = false;
            this.savedBeatWidth = this.totalBeatWidth;
            this.savedBeatWidth2 = 0;
            double d2 = this.metre - this.beatCounter % this.metre;
            for (d = this.phrase.getNote(n).getRhythmValue(); d2 < d; d -= d2) {
                this.isTied = true;
                this.drawNote(n2, d2, n5);
                d2 = this.metre - this.beatCounter % this.metre;
            }
            this.drawNote(n2, d, n5);
        }
        for (n = 0; n < 5; ++n) {
            this.g.drawLine(this.rightMargin, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight, this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight);
        }
        this.g.setColor(Color.lightGray);
        for (n = 0; n < 5; ++n) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight, this.totalBeatWidth + 50, this.bPos + this.imageHeightOffset - 2 * this.staveSpaceHeight + n * this.staveSpaceHeight);
        }
        this.g.setColor(Color.black);
        this.g.drawImage(this.trebleClef, this.rightMargin + 7, this.bPos - 4, this);
        graphics.drawImage(this.image, 0, 0, null);
        this.g.setColor(this.getBackground());
        this.g.fillRect(0, 0, 2000, 500);
        this.g.setColor(this.getForeground());
    }

    private void drawNote(int n, double d, int n2) {
        this.requiresMoreThanOneImage = false;
        this.excessRhythmValue = 0.0;
        this.chooseImage(n, d, 71, 0, 71);
        this.drawNote2(n, d - this.excessRhythmValue, n2);
        if (this.requiresMoreThanOneImage) {
            this.drawNote(n, this.excessRhythmValue, n2);
            this.extraImagesUsed = true;
        }
    }

    private void drawNote2(int n, double d, int n2) {
        if (n != Integer.MIN_VALUE && d != 0.0) {
            Accidental accidental = this.style.selectAccidental(n, d);
            if (accidental == Accidental.SHARP) {
                if (!this.firstAccidentalDisplayed) {
                    this.displayImage(this.g, this.sharp, this.totalBeatWidth - 9, n2);
                }
            } else if (accidental == Accidental.FLAT) {
                n2 -= 4;
                if (!this.firstAccidentalDisplayed) {
                    this.displayImage(this.g, this.flat, this.totalBeatWidth - 9, n2);
                }
                ++n;
                this.semitoneShiftUp = true;
            } else if (accidental == Accidental.NATURAL && !this.firstAccidentalDisplayed) {
                this.displayImage(this.g, this.natural, this.totalBeatWidth - 7, n2);
            }
        }
        this.firstAccidentalDisplayed = true;
        this.displayImage(this.g, this.currImage, this.totalBeatWidth, n2);
        this.notePositions.addElement(new Integer(this.totalBeatWidth));
        this.notePositions.addElement(new Integer(n2));
        if (this.dottedNote) {
            boolean bl = true;
            for (int i = 0; i < this.lineNotes.length; ++i) {
                if (this.lineNotes[i] + 12 != n && this.lineNotes[i] + 36 != n && this.lineNotes[i] + 60 != n && this.lineNotes[i] + 84 != n && this.lineNotes[i] + 108 != n && n != Integer.MIN_VALUE) continue;
                this.displayImage(this.g, this.dot, this.totalBeatWidth + 1, n2 - 4);
                bl = false;
                i = this.lineNotes.length;
            }
            if (bl) {
                this.displayImage(this.g, this.dot, this.totalBeatWidth + 1, n2);
            }
        }
        if (n <= 61 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 52, this.totalBeatWidth + 12, this.bPos + 52);
        }
        if (n <= 58 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 60, this.totalBeatWidth + 12, this.bPos + 60);
        }
        if (n <= 54 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 68, this.totalBeatWidth + 12, this.bPos + 68);
        }
        if (n <= 51 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 76, this.totalBeatWidth + 12, this.bPos + 76);
        }
        if (n <= 48 && n > -1 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 84, this.totalBeatWidth + 12, this.bPos + 84);
        }
        if (n >= 81 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos + 4, this.totalBeatWidth + 12, this.bPos + 4);
        }
        if (n >= 84 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 4, this.totalBeatWidth + 12, this.bPos - 4);
        }
        if (n >= 88 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 12, this.totalBeatWidth + 12, this.bPos - 12);
        }
        if (n >= 91 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 20, this.totalBeatWidth + 12, this.bPos - 20);
        }
        if (n >= 95 && n < 128 && d != 0.0) {
            this.g.drawLine(this.totalBeatWidth - 3, this.bPos - 28, this.totalBeatWidth + 12, this.bPos - 28);
        }
        this.savedBeatWidth2 = this.totalBeatWidth;
        if ((this.isTied || this.extraImagesUsed) && this.isNote && !this.isFirstNoteInTie) {
            int n3 = n2 + 19 - (this.semitoneShiftUp ? 4 : 0);
            if (this.isUp) {
                this.g.drawImage(this.tieUnder, this.savedBeatWidth - 3 + 9, n3 + 17, this.savedBeatWidth2 + 19 - 9, n3 + 17 + this.tieUnder.getHeight(this), 0, 0, this.tieUnder.getWidth(this), this.tieUnder.getHeight(this), this);
            } else {
                this.g.drawImage(this.tieOver, this.savedBeatWidth - 3 + 9, n3 - 20, this.savedBeatWidth2 + 19 - 9, n3 - 20 + this.tieOver.getHeight(this), 0, 0, this.tieOver.getWidth(this), this.tieOver.getHeight(this), this);
            }
        }
        this.isFirstNoteInTie = true;
        if (true) {
            this.isFirstNoteInTie = false;
        }
        this.savedBeatWidth = this.totalBeatWidth;
        this.totalBeatWidth += this.currBeatWidth;
        this.dottedNote = false;
        this.beatCounter += (double)((int)(d / 0.25)) * 0.25;
        if (this.metre != 0.0 && this.beatCounter % this.metre == 0.0) {
            this.g.drawLine(this.totalBeatWidth, this.bPos + 12, this.totalBeatWidth, this.bPos + 44);
            this.style.processBarLine();
            if (this.barNumbers) {
                this.g.drawString("" + (int)(this.beatCounter / this.metre + 1.0 + this.phrase.getStartTime()), this.totalBeatWidth - 4, this.bPos);
            }
            this.totalBeatWidth += 12;
        }
    }

    private void displayImage(Graphics graphics, Image image, int n, int n2) {
        graphics.drawImage(image, n, n2, this);
    }

    public static abstract class Style {
        int[] sharpPitches = new int[]{77, 72, 79, 74, 69, 76, 71};
        int[] flatPitches = new int[]{71, 76, 69, 74, 67, 72, 65};
        public static final Style TRADITIONAL = new Trad();
        public static final Style JMUSIC = new JMusic();
        private String name;

        Style(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name + " of displaying accidentals";
        }

        abstract void initialise(int var1);

        abstract Accidental selectAccidental(int var1, double var2);

        abstract void processBarLine();

        private static final class JMusic
        extends Style {
            private Vector chromaticallyAffectedPitches = new Vector();
            private int keySignature;
            private int keyAccidentals;

            public JMusic() {
                super("JMusic style (with superfluous sharps and flats)");
                this.initialise(0);
            }

            void initialise(int n) {
                block5: {
                    block4: {
                        this.chromaticallyAffectedPitches = new Vector();
                        this.keySignature = n;
                        this.keyAccidentals = 0;
                        if (n <= 0 || n >= 8) break block4;
                        for (int i = 0; i < n; ++i) {
                            int n2 = this.sharpPitches[i] % 12;
                            for (int j = 0; j <= 127; ++j) {
                                if (j % 12 != n2) continue;
                                this.chromaticallyAffectedPitches.addElement(new Integer(j));
                                ++this.keyAccidentals;
                            }
                        }
                        break block5;
                    }
                    if (n >= 0 || n <= -8) break block5;
                    for (int i = 0; i > n; --i) {
                        int n3 = this.flatPitches[-i] % 12;
                        for (int j = 0; j <= 127; ++j) {
                            if (j % 12 != n3) continue;
                            this.chromaticallyAffectedPitches.addElement(new Integer(j));
                            ++this.keyAccidentals;
                        }
                    }
                }
            }

            Accidental selectAccidental(int n, double d) {
                if (n == Integer.MIN_VALUE || d == 0.0) {
                    return Accidental.NONE;
                }
                if (n % 12 == 1 || n % 12 == 3 || n % 12 == 6 || n % 12 == 8 || n % 12 == 10) {
                    if (this.keySignature > -1) {
                        this.chromaticallyAffectedPitches.addElement(new Integer(n - 1));
                        return Accidental.SHARP;
                    }
                    this.chromaticallyAffectedPitches.addElement(new Integer(n + 1));
                    return Accidental.FLAT;
                }
                int n2 = this.chromaticallyAffectedPitches.size();
                for (int i = 0; i < n2; ++i) {
                    int n3 = (Integer)this.chromaticallyAffectedPitches.elementAt(i);
                    if (n3 != n) continue;
                    if (i > this.keyAccidentals - 1) {
                        this.chromaticallyAffectedPitches.removeElementAt(i);
                    }
                    return Accidental.NATURAL;
                }
                return Accidental.NONE;
            }

            void processBarLine() {
            }
        }

        private static final class Trad
        extends Style {
            private boolean[] accidentalRequiredByKeySignature = new boolean[12];
            private static final int[] SHARP_ACCIDENTAL_PAIRS = new int[]{0, 0, 1, 1, 2, 3, 3, 4, 4, 5, 5, 6};
            private static final int[] FLAT_ACCIDENTAL_PAIRS = new int[]{0, 1, 1, 2, 2, 3, 4, 4, 5, 5, 6, 6};
            private int[] degreeToAccidentalPair = SHARP_ACCIDENTAL_PAIRS;
            private boolean[] accidentalInEffect = new boolean[7];
            private int keySignature = 0;

            public Trad() {
                super("Traditional style");
                this.initialise(0);
            }

            private void setBooleanArrayToFalse(boolean[] blArray) {
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = false;
                }
            }

            void initialise(int n) {
                this.keySignature = n;
                this.degreeToAccidentalPair = n < 0 ? FLAT_ACCIDENTAL_PAIRS : SHARP_ACCIDENTAL_PAIRS;
                this.setBooleanArrayToFalse(this.accidentalRequiredByKeySignature);
                this.accidentalRequiredByKeySignature[1] = true;
                this.accidentalRequiredByKeySignature[3] = true;
                this.accidentalRequiredByKeySignature[6] = true;
                this.accidentalRequiredByKeySignature[8] = true;
                this.accidentalRequiredByKeySignature[10] = true;
                for (int i = 0; i < Math.abs(n); ++i) {
                    if (n < 0) {
                        this.accidentalRequiredByKeySignature[this.flatPitches[i] % 12] = true;
                        this.accidentalRequiredByKeySignature[(this.flatPitches[i] - 1) % 12] = false;
                        continue;
                    }
                    this.accidentalRequiredByKeySignature[this.sharpPitches[i] % 12] = true;
                    this.accidentalRequiredByKeySignature[(this.sharpPitches[i] + 1) % 12] = false;
                }
                this.setBooleanArrayToFalse(this.accidentalInEffect);
            }

            Accidental selectAccidental(int n, double d) {
                if (n == Integer.MIN_VALUE || d == 0.0) {
                    return Accidental.NONE;
                }
                int n2 = n % 12;
                int n3 = this.degreeToAccidentalPair[n2];
                if (this.accidentalRequiredByKeySignature[n2] ^ this.accidentalInEffect[n3]) {
                    boolean bl = this.accidentalInEffect[n3] = !this.accidentalInEffect[n3];
                    if (n2 == 1 || n2 == 3 || n2 == 6 || n2 == 8 || n2 == 10) {
                        if (this.keySignature > -1) {
                            return Accidental.SHARP;
                        }
                        return Accidental.FLAT;
                    }
                    return Accidental.NATURAL;
                }
                return Accidental.NONE;
            }

            void processBarLine() {
                this.setBooleanArrayToFalse(this.accidentalInEffect);
            }
        }
    }

    private static final class Accidental {
        public static final Accidental NONE = new Accidental("none");
        public static final Accidental SHARP = new Accidental("sharp");
        public static final Accidental NATURAL = new Accidental("natural");
        public static final Accidental FLAT = new Accidental("flat");
        private String name;

        Accidental(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }
}

