/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.helper;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import jm.JMC;
import jm.audio.Instrument;
import jm.midi.MidiSynth;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Play;
import jm.util.Read;
import jm.util.View;
import jm.util.Write;

public class HelperGUI
extends Frame
implements JMC,
ActionListener,
AdjustmentListener {
    protected Score score = new Score();
    private Button composeBtn;
    private Button playBtn;
    private Button stopBtn;
    private Button showBtn;
    private Button sketchBtn;
    private Button histogramBtn;
    private Button printBtn;
    private Button saveBtn;
    private Button renderBtn;
    private Button notateBtn;
    private Button audioViewBtn;
    private Button audioPlayBtn;
    private Button audioStopBtn;
    private Button xmlOpenBtn;
    private Button xmlSaveBtn;
    private TextField midiName;
    private TextField audioName;
    private Scrollbar sliderA;
    private Scrollbar sliderB;
    private Scrollbar sliderC;
    private Scrollbar sliderD;
    private Scrollbar sliderE;
    private Label labelA;
    private Label labelB;
    private Label labelC;
    private Label labelD;
    private Label labelE;
    private Label commentLabA;
    private Label commentLabB;
    private Label commentLabC;
    private Label commentLabD;
    private Label commentLabE;
    protected Instrument[] insts;
    protected int variableA;
    protected int variableB;
    protected int variableC;
    protected int variableD;
    protected int variableE;
    private MidiSynth ms = new MidiSynth();
    private boolean playing = false;

    public HelperGUI() {
        super("jMusic Helper GUI");
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(13, 1));
        this.add((Component)panel, "North");
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(6, 1));
        this.add((Component)panel2, "Center");
        Panel panel3 = new Panel();
        Panel panel4 = new Panel();
        Panel panel5 = new Panel();
        Panel panel6 = new Panel();
        Panel panel7 = new Panel();
        Panel panel8 = new Panel();
        Panel panel9 = new Panel();
        Panel panel10 = new Panel();
        Label label = new Label("Create and View");
        label.setAlignment(1);
        panel.add(label);
        panel.add(panel3);
        panel.add(panel4);
        panel.add(panel5);
        Label label2 = new Label("MIDI Options");
        label2.setAlignment(1);
        panel.add(label2);
        panel.add(panel7);
        panel.add(panel6);
        Label label3 = new Label("Audio Options");
        label3.setAlignment(1);
        panel.add(label3);
        panel.add(panel9);
        panel.add(panel8);
        Label label4 = new Label("XML Options");
        label4.setAlignment(1);
        panel.add(label4);
        panel.add(panel10);
        Label label5 = new Label("Control compositional parameters");
        label5.setAlignment(1);
        panel.add(label5);
        this.composeBtn = new Button("Compose");
        this.composeBtn.addActionListener(this);
        panel3.add(this.composeBtn);
        this.playBtn = new Button("Play.midi()");
        this.playBtn.addActionListener(this);
        this.playBtn.setEnabled(false);
        panel7.add(this.playBtn);
        this.stopBtn = new Button("Stop MIDI");
        this.stopBtn.addActionListener(this);
        this.stopBtn.setEnabled(false);
        panel7.add(this.stopBtn);
        this.showBtn = new Button("View.show()");
        this.showBtn.addActionListener(this);
        this.showBtn.setEnabled(false);
        panel4.add(this.showBtn);
        this.notateBtn = new Button("View.notate()");
        this.notateBtn.addActionListener(this);
        this.notateBtn.setEnabled(false);
        panel4.add(this.notateBtn);
        this.printBtn = new Button("View.print()");
        this.printBtn.addActionListener(this);
        this.printBtn.setEnabled(false);
        panel4.add(this.printBtn);
        this.sketchBtn = new Button("View.sketch()");
        this.sketchBtn.addActionListener(this);
        this.sketchBtn.setEnabled(false);
        panel5.add(this.sketchBtn);
        this.histogramBtn = new Button("View.histogram()");
        this.histogramBtn.addActionListener(this);
        this.histogramBtn.setEnabled(false);
        panel5.add(this.histogramBtn);
        this.saveBtn = new Button("Write.midi()");
        this.saveBtn.addActionListener(this);
        this.saveBtn.setEnabled(false);
        panel6.add(this.saveBtn);
        this.midiName = new TextField("FileName.mid", 20);
        panel6.add(this.midiName);
        this.audioViewBtn = new Button("View.au()");
        this.audioViewBtn.addActionListener(this);
        this.audioViewBtn.setEnabled(false);
        panel8.add(this.audioViewBtn);
        this.renderBtn = new Button("Write.au()");
        this.renderBtn.addActionListener(this);
        this.renderBtn.setEnabled(false);
        panel9.add(this.renderBtn);
        this.audioName = new TextField("FileName.au", 20);
        panel9.add(this.audioName);
        this.audioPlayBtn = new Button("Play.au()");
        this.audioPlayBtn.addActionListener(this);
        this.audioPlayBtn.setEnabled(false);
        panel8.add(this.audioPlayBtn);
        this.xmlOpenBtn = new Button("Read.xml()");
        this.xmlOpenBtn.addActionListener(this);
        this.xmlOpenBtn.setEnabled(true);
        panel10.add(this.xmlOpenBtn);
        this.xmlSaveBtn = new Button("Write.xml()");
        this.xmlSaveBtn.addActionListener(this);
        this.xmlSaveBtn.setEnabled(false);
        panel10.add(this.xmlSaveBtn);
        Panel panel11 = new Panel(new GridLayout(1, 3));
        this.labelA = new Label(" variableA = 0");
        panel11.add(this.labelA);
        this.sliderA = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderA.addAdjustmentListener(this);
        panel11.add(this.sliderA);
        this.commentLabA = new Label(" No Comment ");
        panel11.add(this.commentLabA);
        panel2.add(panel11);
        Panel panel12 = new Panel(new GridLayout(1, 3));
        this.labelB = new Label(" variableB = 0");
        panel12.add(this.labelB);
        this.sliderB = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderB.addAdjustmentListener(this);
        panel12.add(this.sliderB);
        this.commentLabB = new Label(" No Comment ");
        panel12.add(this.commentLabB);
        panel2.add(panel12);
        Panel panel13 = new Panel(new GridLayout(1, 3));
        this.labelC = new Label(" variableC = 0");
        panel13.add(this.labelC);
        this.sliderC = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderC.addAdjustmentListener(this);
        panel13.add(this.sliderC);
        this.commentLabC = new Label(" No Comment ");
        panel13.add(this.commentLabC);
        panel2.add(panel13);
        Panel panel14 = new Panel(new GridLayout(1, 3));
        this.labelD = new Label(" variableD = 0");
        panel14.add(this.labelD);
        this.sliderD = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderD.addAdjustmentListener(this);
        panel14.add(this.sliderD);
        this.commentLabD = new Label(" No Comment ");
        panel14.add(this.commentLabD);
        panel2.add(panel14);
        Panel panel15 = new Panel(new GridLayout(1, 3));
        this.labelE = new Label(" variableE = 0");
        panel15.add(this.labelE);
        this.sliderE = new Scrollbar(0, 0, 15, 0, 142);
        this.sliderE.addAdjustmentListener(this);
        panel15.add(this.sliderE);
        this.commentLabE = new Label(" No Comment ");
        panel15.add(this.commentLabE);
        panel2.add(panel15);
        Label label6 = new Label(" ");
        panel2.add(label6);
        this.setBounds(0, 0, 350, 600);
        this.setVisible(true);
        this.composeBtn.requestFocus();
    }

    public void setVariableA(int n) {
        this.setVariableA(n, "No Comment");
    }

    public void setVariableA(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderA.setValue(n);
            this.labelA.setText(" variableA = " + n + "  ");
            this.variableA = n;
        }
        if (string.length() > 18) {
            this.commentLabA.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabA.setText(" " + string + " ");
        }
    }

    public void setVariableB(int n) {
        this.setVariableB(n, "No Comment");
    }

    public void setVariableB(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderB.setValue(n);
            this.labelB.setText(" variableB = " + n + "  ");
            this.variableB = n;
        }
        if (string.length() > 18) {
            this.commentLabB.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabB.setText(" " + string + " ");
        }
    }

    public void setVariableC(int n) {
        this.setVariableC(n, "No Comment");
    }

    public void setVariableC(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderC.setValue(n);
            this.labelC.setText(" variableC = " + n + "  ");
            this.variableC = n;
        }
        if (string.length() > 18) {
            this.commentLabC.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabC.setText(" " + string + " ");
        }
    }

    public void setVariableD(int n) {
        this.setVariableD(n, "No Comment");
    }

    public void setVariableD(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderD.setValue(n);
            this.labelD.setText(" variableD = " + n + "  ");
            this.variableD = n;
        }
        if (string.length() > 18) {
            this.commentLabD.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabD.setText(" " + string + " ");
        }
    }

    public void setVariableE(int n) {
        this.setVariableE(n, "No Comment");
    }

    public void setVariableE(int n, String string) {
        if (n >= 0 && n <= 127) {
            this.sliderE.setValue(n);
            this.labelE.setText(" variableE = " + n + "  ");
            this.variableE = n;
        }
        if (string.length() > 18) {
            this.commentLabE.setText(" " + string.substring(0, 16) + "...");
        } else {
            this.commentLabE.setText(" " + string + " ");
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.composeBtn) {
            this.composeScore();
        }
        if (actionEvent.getSource() == this.playBtn) {
            this.playScore();
        }
        if (actionEvent.getSource() == this.stopBtn) {
            this.stopScore();
        }
        if (actionEvent.getSource() == this.showBtn) {
            this.showScore();
        }
        if (actionEvent.getSource() == this.notateBtn) {
            this.notateScore();
        }
        if (actionEvent.getSource() == this.printBtn) {
            this.printScore();
        }
        if (actionEvent.getSource() == this.sketchBtn) {
            this.sketchScore();
        }
        if (actionEvent.getSource() == this.histogramBtn) {
            this.histogramScore();
        }
        if (actionEvent.getSource() == this.saveBtn) {
            this.saveScore();
        }
        if (actionEvent.getSource() == this.renderBtn) {
            this.renderScore();
        }
        if (actionEvent.getSource() == this.audioViewBtn) {
            this.viewAudio();
        }
        if (actionEvent.getSource() == this.audioPlayBtn) {
            this.playAudio();
        }
        if (actionEvent.getSource() == this.audioStopBtn) {
            this.stopAudio();
        }
        if (actionEvent.getSource() == this.xmlOpenBtn) {
            this.xmlOpen();
        }
        if (actionEvent.getSource() == this.xmlSaveBtn) {
            this.xmlSave();
        }
    }

    private void composeScore() {
        this.score = this.compose();
        this.makeBtnsVisible();
    }

    private void makeBtnsVisible() {
        this.playBtn.setEnabled(true);
        this.stopBtn.setEnabled(true);
        this.showBtn.setEnabled(true);
        this.notateBtn.setEnabled(true);
        this.printBtn.setEnabled(true);
        this.sketchBtn.setEnabled(true);
        this.histogramBtn.setEnabled(true);
        this.saveBtn.setEnabled(true);
        this.xmlSaveBtn.setEnabled(true);
        if (this.insts != null) {
            this.renderBtn.setEnabled(true);
        }
    }

    protected Score compose() {
        Phrase phrase = new Phrase();
        Score score = new Score(new Part(phrase));
        Note note = new Note(48 + (int)(Math.random() * (double)this.variableA), 0.5 + (double)this.variableB * 0.25);
        phrase.addNote(note);
        return score;
    }

    private void playScore() {
        if (this.playing) {
            this.ms.stop();
        }
        try {
            this.ms.play(this.score);
            this.playing = true;
        }
        catch (Exception exception) {
            System.err.println("JavaSound MIDI Playback Error:" + exception);
            return;
        }
    }

    private void stopScore() {
        if (this.playing) {
            this.ms.stop();
            this.playing = false;
        }
    }

    private void showScore() {
        View.show(this.score, this.getSize().width + 15, 0);
    }

    private void notateScore() {
        View.notate(this.score, this.getSize().width + 15, 0);
    }

    private void printScore() {
        View.print(this.score);
    }

    private void histogramScore() {
        View.histogram(this.score, 0, this.getSize().width + 15, 0);
    }

    private void sketchScore() {
        View.sketch(this.score, this.getSize().width + 15, 0);
    }

    private void saveScore() {
        String string = this.midiName.getText().trim();
        if (string != null) {
            Write.midi(this.score, string);
        } else {
            Write.midi(this.score);
        }
    }

    private void renderScore() {
        String string = this.audioName.getText().trim();
        if (string != null) {
            Write.au(this.score, string, this.insts);
        } else {
            Write.au(this.score, "RenderedFile.au", this.insts);
            this.audioName.setText("RenderedFile.au");
        }
        this.audioViewBtn.setEnabled(true);
        this.audioPlayBtn.setEnabled(true);
    }

    private void viewAudio() {
        View.au(this.audioName.getText().trim(), this.getSize().width + 5, 0);
    }

    private void playAudio() {
        Play.au(this.audioName.getText().trim(), false);
    }

    private void stopAudio() {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.sliderA) {
            this.labelA.setText(" variableA = " + this.sliderA.getValue());
            this.variableA = new Integer(this.sliderA.getValue());
        }
        if (adjustmentEvent.getSource() == this.sliderB) {
            this.labelB.setText(" variableB = " + this.sliderB.getValue());
            this.variableB = new Integer(this.sliderB.getValue());
        }
        if (adjustmentEvent.getSource() == this.sliderC) {
            this.labelC.setText(" variableC = " + this.sliderC.getValue());
            this.variableC = new Integer(this.sliderC.getValue());
        }
        if (adjustmentEvent.getSource() == this.sliderD) {
            this.labelD.setText(" variableD = " + this.sliderD.getValue());
            this.variableD = new Integer(this.sliderD.getValue());
        }
        if (adjustmentEvent.getSource() == this.sliderE) {
            this.labelE.setText(" variableE = " + this.sliderE.getValue());
            this.variableE = new Integer(this.sliderE.getValue());
        }
    }

    private void xmlSave() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Save as a jMusic XML file...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.xml(this.score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    private void xmlOpen() {
        Read.xml(this.score);
        this.makeBtnsVisible();
    }
}

