/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.histogram;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jm.JMC;
import jm.gui.histogram.Histogram;
import jm.music.data.Score;
import jm.util.Read;

public class HistogramFrame
extends Frame
implements WindowListener,
ActionListener,
JMC {
    private Score score = new Score();
    private MenuItem showPitch;
    private MenuItem showRhythm;
    private MenuItem showDynamic;
    private MenuItem showPan;
    private MenuItem open;
    private MenuItem openXml;
    private MenuItem saveAs;
    private MenuItem quit;
    private Histogram histo;

    public HistogramFrame() {
        this(new Score(), 0);
    }

    public HistogramFrame(Score score) {
        this(score, 0);
    }

    public HistogramFrame(Score score, int n) {
        this(score, n, 0, 0);
    }

    public HistogramFrame(Score score, int n, int n2, int n3) {
        super(score.getTitle());
        this.score = score;
        this.setTitle(n);
        this.setBackground(Color.white);
        this.setSize(350, 558);
        this.histo = new Histogram(score, n, 0, 0, this.getSize().width);
        this.setLocation(n2, n3);
        this.add(this.histo);
        this.addWindowListener(this);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Histogram", true);
        this.showPitch = new MenuItem("Pitch", new MenuShortcut(80));
        this.showPitch.addActionListener(this);
        menu.add(this.showPitch);
        this.showRhythm = new MenuItem("Rhythm", new MenuShortcut(82));
        this.showRhythm.addActionListener(this);
        menu.add(this.showRhythm);
        this.showDynamic = new MenuItem("Dynamic", new MenuShortcut(68));
        this.showDynamic.addActionListener(this);
        menu.add(this.showDynamic);
        this.showPan = new MenuItem("Pan", new MenuShortcut(80, true));
        this.showPan.addActionListener(this);
        menu.add(this.showPan);
        MenuItem menuItem = new MenuItem("-");
        menu.add(menuItem);
        this.open = new MenuItem("Open MIDI file...", new MenuShortcut(79));
        this.open.addActionListener(this);
        menu.add(this.open);
        this.openXml = new MenuItem("Open jMusic XML file...");
        this.openXml.addActionListener(this);
        menu.add(this.openXml);
        this.saveAs = new MenuItem("Save data as...", new MenuShortcut(83));
        this.saveAs.addActionListener(this);
        menu.add(this.saveAs);
        MenuItem menuItem2 = new MenuItem("-");
        menu.add(menuItem2);
        this.quit = new MenuItem("Quit", new MenuShortcut(81));
        this.quit.addActionListener(this);
        menu.add(this.quit);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.setVisible(true);
    }

    private void setTitle(int n) {
        if (n == 0) {
            this.setTitle("jMusic Pitch Histogram: '" + this.score.getTitle() + "'");
        }
        if (n == 1) {
            this.setTitle("jMusic Rhythm Histogram: '" + this.score.getTitle() + "'");
        }
        if (n == 2) {
            this.setTitle("jMusic Dynamic Histogram: '" + this.score.getTitle() + "'");
        }
        if (n == 3) {
            this.setTitle("jMusic Pan Histogram: '" + this.score.getTitle() + "'");
        }
    }

    private void changeDataType(int n) {
        this.setTitle(n);
        this.histo.setType(n);
        this.repaint();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.showPitch) {
            this.changeDataType(0);
        }
        if (actionEvent.getSource() == this.showRhythm) {
            this.changeDataType(1);
        }
        if (actionEvent.getSource() == this.showDynamic) {
            this.changeDataType(2);
        }
        if (actionEvent.getSource() == this.showPan) {
            this.changeDataType(3);
        }
        if (actionEvent.getSource() == this.open) {
            this.openMIDIFile();
        }
        if (actionEvent.getSource() == this.openXml) {
            this.openXMLFile();
        }
        if (actionEvent.getSource() == this.saveAs) {
            this.histo.saveData();
        }
        if (actionEvent.getSource() == this.quit) {
            System.exit(0);
        }
    }

    public void openMIDIFile() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select a MIDI file to display.", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            Score score = new Score();
            Read.midi(score, fileDialog.getDirectory() + string);
            this.score = score;
            this.histo.setScore(score);
            this.changeDataType(0);
        }
    }

    public void openXMLFile() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select a jMusic XML file to display.", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            Score score = new Score();
            Read.xml(score, fileDialog.getDirectory() + string);
            this.score = score;
            this.histo.setScore(score);
            this.changeDataType(0);
        }
    }
}

