/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.show;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.util.Enumeration;
import jm.gui.show.ShowPanel;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;

public class ShowArea
extends Canvas {
    private int oldX;
    private int maxColours = 8;
    private float[][] theColours = new float[this.maxColours][3];
    private int noteHeight = 5;
    private int w = 2 * this.noteHeight;
    private int ePos = 5 * this.noteHeight;
    private int e = this.ePos + this.noteHeight * 33;
    private int areaHeight = 77 * this.noteHeight;
    private int[] noteOffset = new int[]{0, 0, this.noteHeight, this.noteHeight, this.noteHeight * 2, this.noteHeight * 3, this.noteHeight * 3, this.noteHeight * 4, this.noteHeight * 4, this.noteHeight * 5, this.noteHeight * 5, this.noteHeight * 6};
    private Font font = new Font("Helvetica", 0, 10);
    private ShowPanel sp;
    private double beatWidth;
    private int thinNote = 2;

    public ShowArea(ShowPanel showPanel) {
        this.sp = showPanel;
        this.setSize((int)(showPanel.score.getEndTime() * showPanel.beatWidth), this.areaHeight);
        for (int i = 0; i < this.maxColours; ++i) {
            this.theColours[i][0] = (float)(Math.random() / (double)this.maxColours / 2.0) + (float)(1.0 / (double)this.maxColours * (double)i);
            this.theColours[i][1] = (float)(Math.random() / (double)this.maxColours) + (float)(1.0 / (double)this.maxColours * (double)i);
        }
    }

    private void reInit() {
        this.w = 2 * this.noteHeight;
        this.ePos = 5 * this.noteHeight;
        this.e = this.ePos + this.noteHeight * 33;
        this.areaHeight = 77 * this.noteHeight;
        this.noteOffset = new int[]{0, 0, this.noteHeight, this.noteHeight, this.noteHeight * 2, this.noteHeight * 3, this.noteHeight * 3, this.noteHeight * 4, this.noteHeight * 4, this.noteHeight * 5, this.noteHeight * 5, this.noteHeight * 6};
        this.setSize(new Dimension(this.getSize().width, this.areaHeight));
        this.sp.updatePanelHeight();
    }

    public int getHeight() {
        return this.areaHeight;
    }

    public void setNoteHeight(int n) {
        this.noteHeight = n;
        this.reInit();
        this.repaint();
    }

    public void setThinNote(int n) {
        if (n >= 0) {
            this.thinNote = n;
        }
        this.repaint();
    }

    public int getThinNote() {
        return this.thinNote;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        graphics.setFont(this.font);
        graphics.setColor(Color.black);
        this.beatWidth = this.sp.beatWidth;
        int n = (int)Math.round(this.sp.score.getEndTime() * this.beatWidth);
        graphics.drawLine(0, this.e, n, this.e);
        graphics.drawLine(0, this.e - this.w, n, this.e - this.w);
        graphics.drawLine(0, this.e - this.w * 2, n, this.e - this.w * 2);
        graphics.drawLine(0, this.e - this.w * 3, n, this.e - this.w * 3);
        graphics.drawLine(0, this.e - this.w * 4, n, this.e - this.w * 4);
        graphics.drawLine(0, this.e + this.w * 2, n, this.e + this.w * 2);
        graphics.drawLine(0, this.e + this.w * 3, n, this.e + this.w * 3);
        graphics.drawLine(0, this.e + this.w * 4, n, this.e + this.w * 4);
        graphics.drawLine(0, this.e + this.w * 5, n, this.e + this.w * 5);
        graphics.drawLine(0, this.e + this.w * 6, n, this.e + this.w * 6);
        graphics.setColor(Color.lightGray);
        graphics.drawLine(0, this.e - this.w * 7, n, this.e - this.w * 7);
        graphics.drawLine(0, this.e - this.w * 8, n, this.e - this.w * 8);
        graphics.drawLine(0, this.e - this.w * 9, n, this.e - this.w * 9);
        graphics.drawLine(0, this.e - this.w * 10, n, this.e - this.w * 10);
        graphics.drawLine(0, this.e - this.w * 11, n, this.e - this.w * 11);
        graphics.drawLine(0, this.e + this.w * 9, n, this.e + this.w * 9);
        graphics.drawLine(0, this.e + this.w * 10, n, this.e + this.w * 10);
        graphics.drawLine(0, this.e + this.w * 11, n, this.e + this.w * 11);
        graphics.drawLine(0, this.e + this.w * 12, n, this.e + this.w * 12);
        graphics.drawLine(0, this.e + this.w * 13, n, this.e + this.w * 13);
        for (int i = 0; i < n; i += 10) {
            graphics.drawLine(i, this.e + this.w, i + 1, this.e + this.w);
            graphics.drawLine(i, this.e - this.w * 5, i + 1, this.e - this.w * 5);
            graphics.drawLine(i, this.e - this.w * 6, i + 1, this.e - this.w * 6);
            graphics.drawLine(i, this.e - this.w * 12, i + 1, this.e - this.w * 12);
            graphics.drawLine(i, this.e - this.w * 13, i + 1, this.e - this.w * 13);
            graphics.drawLine(i, this.e - this.w * 14, i + 1, this.e - this.w * 14);
            graphics.drawLine(i, this.e - this.w * 15, i + 1, this.e - this.w * 15);
            graphics.drawLine(i, this.e - this.w * 16, i + 1, this.e - this.w * 16);
            graphics.drawLine(i, this.e - this.w * 17, i + 1, this.e - this.w * 17);
            graphics.drawLine(i, this.e - this.w * 18, i + 1, this.e - this.w * 18);
            graphics.drawLine(i, this.e + this.w * 7, i + 1, this.e + this.w * 7);
            graphics.drawLine(i, this.e + this.w * 8, i + 1, this.e + this.w * 8);
            graphics.drawLine(i, this.e + this.w * 14, i + 1, this.e + this.w * 14);
            graphics.drawLine(i, this.e + this.w * 15, i + 1, this.e + this.w * 15);
            graphics.drawLine(i, this.e + this.w * 16, i + 1, this.e + this.w * 16);
            graphics.drawLine(i, this.e + this.w * 17, i + 1, this.e + this.w * 17);
            graphics.drawLine(i, this.e + this.w * 18, i + 1, this.e + this.w * 18);
        }
        Enumeration enumeration = this.sp.score.getPartList().elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            Enumeration enumeration2 = part.getPhraseList().elements();
            while (enumeration2.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration2.nextElement();
                Enumeration enumeration3 = phrase.getNoteList().elements();
                double d = phrase.getStartTime();
                int n3 = this.oldX = (int)Math.round(d * this.beatWidth);
                int n4 = 100000;
                int n5 = this.oldX;
                int n6 = 0;
                while (enumeration3.hasMoreElements()) {
                    Note note = (Note)enumeration3.nextElement();
                    int n7 = -1;
                    n7 = !note.getPitchType() ? note.getPitch() : Note.freqToMidiPitch(note.getFrequency());
                    if (n7 <= 127 && n7 >= 0) {
                        int n8 = this.noteHeight * 7;
                        int n9 = (10 - n7 / 12) * n8 + this.ePos - this.noteOffset[n7 % 12];
                        int n10 = (int)Math.round(note.getDuration() * this.beatWidth);
                        int n11 = (int)Math.round(note.getRhythmValue() * this.beatWidth);
                        if (n10 < 1) {
                            n10 = 1;
                        }
                        if (n9 < n4) {
                            n4 = n9;
                        }
                        if (n9 > n6) {
                            n6 = n9;
                        }
                        graphics.setColor(Color.getHSBColor(this.theColours[n2 % this.maxColours][0], this.theColours[n2 % this.maxColours][1], (float)(0.7 - (double)note.getDynamic() * 0.004)));
                        if (!note.getPitchType()) {
                            graphics.fillRect(this.oldX, n9 - this.noteHeight + this.thinNote, n10, this.noteHeight * 2 - 2 * this.thinNote);
                        } else {
                            int n12 = 7;
                            for (int i = this.oldX; i < this.oldX + n10 - 4; i += 4) {
                                graphics.drawLine(i, n9 - this.noteHeight + n12, i + 2, n9 - this.noteHeight + n12 - 3);
                                graphics.drawLine(i + 2, n9 - this.noteHeight + n12 - 3, i + 4, n9 - this.noteHeight + n12);
                            }
                        }
                        graphics.setColor(Color.getHSBColor(this.theColours[n2 % this.maxColours][0], this.theColours[n2 % this.maxColours][1], 0.4f));
                        graphics.drawRect(this.oldX, n9 - this.noteHeight + this.thinNote, n11, this.noteHeight * 2 - 2 * this.thinNote);
                        if (n7 % 12 == 1 || n7 % 12 == 3 || n7 % 12 == 6 || n7 % 12 == 8 || n7 % 12 == 10) {
                            graphics.setColor(Color.getHSBColor(this.theColours[n2 % this.maxColours][0], this.theColours[n2 % this.maxColours][1], 0.3f));
                            graphics.drawString("#", this.oldX - 7, n9 + 5);
                        }
                    }
                    this.oldX = (int)Math.round((d += note.getRhythmValue()) * this.beatWidth);
                    n5 = this.oldX - n3;
                }
                graphics.setColor(Color.getHSBColor(this.theColours[n2 % this.maxColours][0], this.theColours[n2 % this.maxColours][1], 0.9f));
                graphics.drawRect(n3 - 1, n4 - this.noteHeight - 1, n5 + 1, n6 - n4 + this.noteHeight * 2 + 2);
            }
            ++n2;
        }
    }
}

