/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.show;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.ScrollPane;
import jm.gui.show.ShowArea;
import jm.gui.show.ShowRuler;
import jm.music.data.Score;

public class ShowPanel
extends ScrollPane {
    public Score score;
    protected double beatWidth;
    private ShowArea sa;
    private ShowRuler ruler;
    private Panel pan;
    private Frame frame;
    private int panelHeight;

    public ShowPanel(Frame frame, Score score) {
        super(1);
        this.beatWidth = 650.0 / score.getEndTime();
        if (this.beatWidth < 1.0) {
            this.beatWidth = 1.0;
        }
        if (this.beatWidth > 256.0) {
            this.beatWidth = 256.0;
        }
        this.frame = frame;
        this.score = score;
        this.pan = new Panel();
        this.pan.setLayout(new BorderLayout());
        this.sa = new ShowArea(this);
        this.pan.add("Center", this.sa);
        this.ruler = new ShowRuler(this);
        this.pan.add("South", this.ruler);
        this.setSize(new Dimension(650, 400));
        this.updatePanelHeight();
        this.add(this.pan);
        this.getHAdjustable().setUnitIncrement(50);
        this.getHAdjustable().setBlockIncrement(50);
        this.setScrollPosition(0, 0);
    }

    public void setScore(Score score) {
        this.score = score;
        this.beatWidth = (double)this.getSize().width / score.getEndTime();
        if (this.beatWidth < 1.0) {
            this.beatWidth = 1.0;
        }
        if (this.beatWidth > 256.0) {
            this.beatWidth = 256.0;
        }
        this.update();
    }

    public void updatePanelHeight() {
        this.panelHeight = this.sa.getHeight() + this.ruler.getHeight() + 25;
        this.setSize(new Dimension(this.getSize().width, this.panelHeight));
    }

    public int getHeight() {
        return this.panelHeight;
    }

    public ShowArea getShowArea() {
        return this.sa;
    }

    public void update() {
        this.pan.repaint();
        this.sa.setSize((int)Math.round(this.score.getEndTime() * this.beatWidth), this.sa.getHeight());
        this.sa.repaint();
        this.ruler.repaint();
        this.repaint();
        this.frame.pack();
    }
}

