/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.show;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jm.gui.show.ShowPanel;

public class ShowRuler
extends Canvas
implements MouseListener,
MouseMotionListener {
    private int startX;
    private int height = 15;
    private int timeSig = 2;
    private ShowPanel sp;
    private Font font = new Font("Helvetica", 0, 10);

    public ShowRuler(ShowPanel showPanel) {
        this.sp = showPanel;
        this.setSize((int)(showPanel.score.getEndTime() * showPanel.beatWidth), this.height);
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setCursor(new Cursor(13));
    }

    public int getHeight() {
        return this.height;
    }

    public void paint(Graphics graphics) {
        double d = this.sp.beatWidth;
        graphics.setFont(this.font);
        int n = 0;
        while ((double)n < this.sp.score.getEndTime()) {
            int n2 = (int)Math.round((double)n * d);
            if (n % this.timeSig == 0) {
                graphics.drawLine(n2, 0, n2, this.height);
                if (d > 15.0) {
                    graphics.drawString("" + n, n2 + 2, this.height - 2);
                }
            } else {
                graphics.drawLine(n2, this.height / 2, n2, this.height);
            }
            ++n;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(10));
        this.startX = mouseEvent.getX();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(13));
        this.sp.update();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        double d = this.sp.beatWidth;
        if ((d += ((double)mouseEvent.getX() - (double)this.startX) / 5.0) < 1.0) {
            d = 1.0;
        }
        if (d > 256.0) {
            d = 256.0;
        }
        this.sp.beatWidth = d;
        this.startX = mouseEvent.getX();
        this.repaint();
    }
}

