/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.show;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import jm.gui.show.ShowPanel;
import jm.music.data.Score;
import jm.util.Play;
import jm.util.Read;
import jm.util.Write;

public class ShowScore
extends Frame
implements WindowListener,
ActionListener {
    private Panel pan;
    private Score score = new Score();
    private MenuItem saveMIDI;
    private MenuItem quit;
    private MenuItem size7;
    private MenuItem size2;
    private MenuItem size3;
    private MenuItem size4;
    private MenuItem size5;
    private MenuItem size6;
    private MenuItem size8;
    private MenuItem thin;
    private MenuItem medium;
    private MenuItem thick;
    private MenuItem play;
    private MenuItem saveXML;
    private MenuItem openXML;
    private MenuItem openMIDI;
    private ShowPanel sp;

    public ShowScore(Score score) {
        this(score, 0, 0);
    }

    public ShowScore(Score score, int n, int n2) {
        super("jMusic Show: '" + score.getTitle() + "'");
        this.score = score;
        this.addWindowListener(this);
        this.sp = new ShowPanel(this, score);
        this.setSize(650, this.sp.getHeight() + 25);
        this.add(this.sp);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Show", true);
        this.size2 = new MenuItem("Size 2");
        this.size2.addActionListener(this);
        menu.add(this.size2);
        this.size3 = new MenuItem("Size 3");
        this.size3.addActionListener(this);
        menu.add(this.size3);
        this.size4 = new MenuItem("Size 4");
        this.size4.addActionListener(this);
        menu.add(this.size4);
        this.size5 = new MenuItem("Size 5");
        this.size5.addActionListener(this);
        menu.add(this.size5);
        this.size6 = new MenuItem("Size 6");
        this.size6.addActionListener(this);
        menu.add(this.size6);
        this.size7 = new MenuItem("Size 7");
        this.size7.addActionListener(this);
        menu.add(this.size7);
        this.size8 = new MenuItem("Size 8");
        this.size8.addActionListener(this);
        menu.add(this.size8);
        MenuItem menuItem = new MenuItem("-");
        menu.add(menuItem);
        this.thin = new MenuItem("Thin notes");
        this.thin.addActionListener(this);
        menu.add(this.thin);
        this.medium = new MenuItem("Medium notes");
        this.medium.addActionListener(this);
        menu.add(this.medium);
        this.thick = new MenuItem("Thick notes");
        this.thick.addActionListener(this);
        menu.add(this.thick);
        MenuItem menuItem2 = new MenuItem("-");
        menu.add(menuItem2);
        this.play = new MenuItem("Play MIDI", new MenuShortcut(80));
        this.play.addActionListener(this);
        menu.add(this.play);
        this.openMIDI = new MenuItem("Open a MIDI file...", new MenuShortcut(79));
        this.openMIDI.addActionListener(this);
        menu.add(this.openMIDI);
        this.openXML = new MenuItem("Open a jMusic XML file...");
        this.openXML.addActionListener(this);
        menu.add(this.openXML);
        this.saveMIDI = new MenuItem("Save as MIDI file...", new MenuShortcut(83));
        this.saveMIDI.addActionListener(this);
        menu.add(this.saveMIDI);
        this.saveXML = new MenuItem("Save as jMusic XML file...");
        this.saveXML.addActionListener(this);
        menu.add(this.saveXML);
        this.quit = new MenuItem("Quit", new MenuShortcut(81));
        this.quit.addActionListener(this);
        menu.add(this.quit);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.pack();
        this.setLocation(n, n2);
        this.show();
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.play) {
            this.playBackMidi();
        }
        if (actionEvent.getSource() == this.quit) {
            System.exit(0);
        }
        if (actionEvent.getSource() == this.saveMIDI) {
            this.saveMidi();
        }
        if (actionEvent.getSource() == this.openMIDI) {
            this.openMidi();
        }
        if (actionEvent.getSource() == this.saveXML) {
            this.saveXMLFile();
        }
        if (actionEvent.getSource() == this.openXML) {
            this.openXMLFile();
        }
        if (actionEvent.getSource() == this.size2) {
            this.resize(2);
        }
        if (actionEvent.getSource() == this.size3) {
            this.resize(3);
        }
        if (actionEvent.getSource() == this.size4) {
            this.resize(4);
        }
        if (actionEvent.getSource() == this.size5) {
            this.resize(5);
        }
        if (actionEvent.getSource() == this.size6) {
            this.resize(6);
        }
        if (actionEvent.getSource() == this.size7) {
            this.resize(7);
        }
        if (actionEvent.getSource() == this.size8) {
            this.resize(8);
        }
        if (actionEvent.getSource() == this.thin) {
            this.sp.getShowArea().setThinNote(2);
        }
        if (actionEvent.getSource() == this.medium) {
            this.sp.getShowArea().setThinNote(1);
        }
        if (actionEvent.getSource() == this.thick) {
            this.sp.getShowArea().setThinNote(0);
        }
    }

    private void resize(int n) {
        this.sp.getShowArea().setNoteHeight(n);
        this.setSize(this.getSize().width, this.sp.getHeight() + 25);
        this.pack();
    }

    public void saveMidi() {
        Write.midi(this.score);
    }

    public void saveXMLFile() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Save as a jMusic XML file...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.xml(this.score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public void openMidi() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select a MIDI file to display...", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            Score score = new Score();
            Read.midi(score, fileDialog.getDirectory() + string);
            this.score = score;
            this.sp.setScore(score);
        }
    }

    public void openXMLFile() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select a jMusic XML file to display.", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            Score score = new Score();
            Read.xml(score, fileDialog.getDirectory() + string);
            this.score = score;
            this.sp.setScore(score);
        }
    }

    private void playBackMidi() {
        Play.midi(this.score, false);
    }
}

