/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.sketch;

import java.awt.BorderLayout;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import jm.gui.sketch.SketchRuler;
import jm.gui.sketch.SketchScoreArea;
import jm.midi.MidiSynth;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.util.Read;
import jm.util.Write;

public class SketchScore
extends Frame
implements WindowListener,
ActionListener {
    private static int maxWidth;
    private static int maxParts;
    protected static Score score;
    protected double beatWidth = 10.0;
    private Panel pan;
    private SketchScoreArea sketchScoreArea;
    private SketchRuler ruler;
    private MenuItem play;
    private MenuItem speedUp;
    private MenuItem slowDown;
    private MenuItem clear;
    private MenuItem saveMIDI;
    private MenuItem quit;
    private MenuItem openMIDI;
    private MenuItem openXML;
    private MenuItem saveXML;

    public SketchScore(Score score) {
        this(score, 0, 0);
    }

    public SketchScore(Score score, int n, int n2) {
        super("jMusic Sketch: '" + score.getTitle() + "'");
        SketchScore.score = score;
        this.getWidthAndParts();
        this.addWindowListener(this);
        this.pan = new Panel();
        this.pan.setLayout(new BorderLayout());
        this.sketchScoreArea = new SketchScoreArea(score, maxWidth, this.beatWidth);
        this.sketchScoreArea.setSketchScore(this);
        this.pan.add("Center", this.sketchScoreArea);
        this.ruler = new SketchRuler(this);
        this.pan.add("South", this.ruler);
        ScrollPane scrollPane = new ScrollPane(1);
        scrollPane.getHAdjustable().setUnitIncrement(20);
        scrollPane.add(this.pan);
        this.add(scrollPane);
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("Sketch", true);
        this.play = new MenuItem("Play @ " + score.getTempo() + " bpm", new MenuShortcut(80));
        this.play.addActionListener(this);
        menu.add(this.play);
        this.speedUp = new MenuItem("Speed Up");
        this.speedUp.addActionListener(this);
        menu.add(this.speedUp);
        this.slowDown = new MenuItem("Slow Down");
        this.slowDown.addActionListener(this);
        menu.add(this.slowDown);
        this.clear = new MenuItem("Clear notes");
        this.clear.addActionListener(this);
        menu.add(this.clear);
        MenuItem menuItem = new MenuItem("-");
        menu.add(menuItem);
        this.openMIDI = new MenuItem("Open a MIDI file...", new MenuShortcut(79));
        this.openMIDI.addActionListener(this);
        menu.add(this.openMIDI);
        this.openXML = new MenuItem("Open a jMusic XML file...");
        this.openXML.addActionListener(this);
        menu.add(this.openXML);
        this.saveMIDI = new MenuItem("Save as MIDI file", new MenuShortcut(83));
        this.saveMIDI.addActionListener(this);
        menu.add(this.saveMIDI);
        this.saveXML = new MenuItem("Save as a jMusic XML file");
        this.saveXML.addActionListener(this);
        menu.add(this.saveXML);
        this.quit = new MenuItem("Quit", new MenuShortcut(81));
        this.quit.addActionListener(this);
        menu.add(this.quit);
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.setSize(650, this.sketchScoreArea.getHeight() + this.ruler.getHeight());
        this.setLocation(n, n2);
        this.show();
    }

    public SketchScoreArea getSketchScoreArea() {
        return this.sketchScoreArea;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.dispose();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void update() {
        this.sketchScoreArea.setScore(score);
        this.pan.repaint();
        this.sketchScoreArea.setSize((int)Math.round(score.getEndTime() * this.beatWidth), this.sketchScoreArea.getHeight());
        this.sketchScoreArea.setBeatWidth(this.beatWidth);
        this.sketchScoreArea.repaint();
        this.ruler.repaint();
        this.setSize(this.getSize().width, this.sketchScoreArea.getHeight() + this.ruler.getHeight());
        this.pack();
    }

    private void getWidthAndParts() {
        Enumeration enumeration = score.getPartList().elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            ++maxParts;
            Enumeration enumeration2 = part.getPhraseList().elements();
            while (enumeration2.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration2.nextElement();
                Enumeration enumeration3 = phrase.getNoteList().elements();
                maxWidth = (int)(phrase.getStartTime() * this.beatWidth);
                while (enumeration3.hasMoreElements()) {
                    Note note = (Note)enumeration3.nextElement();
                    maxWidth += (int)(note.getRhythmValue() * this.beatWidth);
                }
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.play) {
            this.playScore();
        }
        if (actionEvent.getSource() == this.speedUp) {
            this.speedItUp();
        }
        if (actionEvent.getSource() == this.slowDown) {
            this.slowItDown();
        }
        if (actionEvent.getSource() == this.clear) {
            this.clearNotes();
        }
        if (actionEvent.getSource() == this.quit) {
            System.exit(0);
        }
        if (actionEvent.getSource() == this.saveMIDI) {
            this.saveMidi();
        }
        if (actionEvent.getSource() == this.openMIDI) {
            this.openMidi();
        }
        if (actionEvent.getSource() == this.saveXML) {
            this.saveXMLFile();
        }
        if (actionEvent.getSource() == this.openXML) {
            this.openXMLFile();
        }
    }

    private void playScore() {
        MidiSynth midiSynth = new MidiSynth();
        try {
            midiSynth.play(score);
        }
        catch (Exception exception) {
            System.err.println("MIDI Playback Error:" + exception);
            return;
        }
    }

    private void speedItUp() {
        double d = score.getTempo() + 10.0;
        if (d > 250.0) {
            d = 250.0;
        }
        score.setTempo(d);
        this.play.setLabel("Play @ " + d + " bpm");
    }

    private void slowItDown() {
        double d = score.getTempo() - 10.0;
        if (d < 20.0) {
            d = 20.0;
        }
        score.setTempo(d);
        this.play.setLabel("Play @ " + d + " bpm");
    }

    private void clearNotes() {
        score.removeAllParts();
        this.sketchScoreArea.repaint();
    }

    public void saveMidi() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Save as a MIDI file...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.midi(score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public void saveXMLFile() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Save as a jMusic XML file...", 1);
        fileDialog.show();
        if (fileDialog.getFile() != null) {
            Write.xml(score, fileDialog.getDirectory() + fileDialog.getFile());
        }
    }

    public void openMidi() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select a MIDI file to display.", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            Score score = new Score();
            Read.midi(score, fileDialog.getDirectory() + string);
            SketchScore.score = score;
            this.update();
        }
    }

    public void openXMLFile() {
        FileDialog fileDialog = new FileDialog(new Frame(), "Select a jMusic XML file to display.", 0);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string != null) {
            Score score = new Score();
            Read.xml(score, fileDialog.getDirectory() + string);
            SketchScore.score = score;
            this.update();
        }
    }
}

