/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.sketch;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;
import jm.JMC;
import jm.gui.sketch.SketchScore;
import jm.music.data.Note;
import jm.music.data.Part;
import jm.music.data.Phrase;
import jm.music.data.Score;
import jm.music.tools.Mod;

public class SketchScoreArea
extends Canvas
implements JMC,
KeyListener,
MouseListener,
MouseMotionListener {
    private Score score;
    private int scoreChannels;
    private int currentChannel;
    private int oldY = 0;
    private Color[] theColors = new Color[10];
    private int maxWidth;
    private double beatWidth;
    private int x;
    private int y;
    private int newWidth = 650;
    private Vector drawPoints = new Vector();
    private int myHeight = 127;
    private SketchScore sc;

    public SketchScoreArea(Score score, int n, double d) {
        this.score = score;
        this.currentChannel = this.scoreChannels = score.size();
        this.maxWidth = n;
        this.beatWidth = d;
        this.setSize(n, this.myHeight);
        this.score = score;
        this.maxWidth = n;
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setBackground(new Color(250, 250, 250));
        for (int i = 0; i < 10; ++i) {
            Color color;
            this.theColors[i] = color = new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0));
        }
    }

    public void setBeatWidth(double d) {
        this.beatWidth = d;
    }

    public void setScore(Score score) {
        this.score = score;
    }

    public int getHeight() {
        return this.myHeight;
    }

    public void setSketchScore(SketchScore sketchScore) {
        this.sc = sketchScore;
    }

    public int getNewWidth() {
        return this.newWidth;
    }

    public void paint(Graphics graphics) {
        Object object;
        this.score.clean();
        Enumeration enumeration = this.score.getPartList().elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            object = (Part)enumeration.nextElement();
            graphics.setColor(this.theColors[n % 10]);
            ++n;
            Enumeration enumeration2 = ((Part)object).getPhraseList().elements();
            while (enumeration2.hasMoreElements()) {
                Phrase phrase = (Phrase)enumeration2.nextElement();
                Enumeration enumeration3 = phrase.getNoteList().elements();
                double d = phrase.getStartTime();
                while (enumeration3.hasMoreElements()) {
                    Note note = (Note)enumeration3.nextElement();
                    int n2 = -1;
                    n2 = !note.getPitchType() ? note.getPitch() : Note.freqToMidiPitch(note.getFrequency());
                    if (n2 != Integer.MIN_VALUE) {
                        int n3 = 127 - n2;
                        int n4 = (int)Math.round(note.getDuration() * this.beatWidth);
                        int n5 = (int)Math.round(d * this.beatWidth);
                        graphics.drawLine(n5, n3, n5 + n4, n3);
                    }
                    d += note.getRhythmValue();
                }
            }
        }
        graphics.setColor(Color.black);
        object = this.drawPoints.elements();
        while (object.hasMoreElements()) {
            int n6 = (Integer)object.nextElement();
            int n7 = (Integer)object.nextElement();
            int n8 = (Integer)object.nextElement();
            int n9 = (Integer)object.nextElement();
            graphics.drawLine(n6, n7, n8, n9);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\b') {
            if (this.score.getPart(0).size() < 1) {
                return;
            }
            Vector vector = this.score.getPartList();
            vector.removeElementAt(vector.size() - 1);
            if (this.sc == null) {
                this.repaint();
            } else {
                this.sc.update();
            }
            this.newWidth = 50;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.drawPoints.addElement(new Integer(this.x));
        this.drawPoints.addElement(new Integer(this.y));
        this.drawPoints.addElement(new Integer(mouseEvent.getX()));
        this.drawPoints.addElement(new Integer(mouseEvent.getY()));
        this.x = mouseEvent.getX();
        this.y = mouseEvent.getY();
        if (mouseEvent.getX() > (int)(this.score.getEndTime() * this.beatWidth) && mouseEvent.getX() > this.newWidth) {
            this.newWidth = mouseEvent.getX();
        }
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.drawPoints.size() > 0) {
            if (mouseEvent.getModifiers() == 24) {
                this.convertLineToPhrase(true);
            } else {
                this.convertLineToPhrase(false);
            }
        }
        this.drawPoints.removeAllElements();
        this.newWidth = 50;
        this.repaint();
    }

    private void convertLineToPhrase(boolean bl) {
        int n;
        Phrase phrase = null;
        double[][] dArray = new double[this.drawPoints.size() / 4][3];
        Enumeration enumeration = this.drawPoints.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            n = (Integer)enumeration.nextElement();
            int n3 = (Integer)enumeration.nextElement();
            int n4 = (Integer)enumeration.nextElement();
            int n5 = (Integer)enumeration.nextElement();
            if (bl) {
                for (int i = 0; i < Math.abs(n3 - n5); ++i) {
                    dArray[n2][0] = (double)((Integer)this.drawPoints.elementAt(n2 * 4)).intValue() / this.beatWidth + ((double)Math.abs(n4 - n) / this.beatWidth / (double)Math.abs(n3 - n5) + 1.0) / (double)(Math.abs(n3 - n5) + 1);
                    if ((Integer)this.drawPoints.elementAt(n2 * 4) > (Integer)this.drawPoints.elementAt(n2 * 4 + 2)) {
                        dArray[n2][0] = (double)((Integer)this.drawPoints.elementAt(n2 * 4 + 2)).intValue() / this.beatWidth / (double)Math.abs(n3 - n5) + 1.0;
                    }
                    dArray[n2][1] = 127 - n3 + i;
                    dArray[n2][2] = (double)Math.abs(n4 - n) / this.beatWidth / (double)Math.abs(n3 - n5) + 1.0;
                }
            } else {
                dArray[n2][0] = (double)((Integer)this.drawPoints.elementAt(n2 * 4)).intValue() / this.beatWidth;
                if ((Integer)this.drawPoints.elementAt(n2 * 4) > (Integer)this.drawPoints.elementAt(n2 * 4 + 2)) {
                    dArray[n2][0] = (double)((Integer)this.drawPoints.elementAt(n2 * 4 + 2)).intValue() / this.beatWidth;
                }
                dArray[n2][1] = 127 - n3;
                dArray[n2][2] = (double)Math.abs(n4 - n) / this.beatWidth;
            }
            ++n2;
        }
        this.quickSort(dArray, 0, dArray.length - 1);
        if (this.drawPoints.size() > 0) {
            phrase = new Phrase(dArray[0][0]);
        }
        for (n = 0; n < dArray.length - 1; ++n) {
            if (dArray[n][1] < 0.0) {
                dArray[n][1] = 0.0;
            }
            if (dArray[n][1] > 127.0) {
                dArray[n][1] = 127.0;
            }
            Note note = new Note((int)dArray[n][1], dArray[n + 1][0] - dArray[n][0]);
            if (n > 0 && !note.getPitchType() && !((Note)phrase.getNoteList().lastElement()).getPitchType()) {
                if (phrase.size() > 0 && note.getPitch() == ((Note)phrase.getNoteList().lastElement()).getPitch()) {
                    Mod.append((Note)phrase.getNoteList().lastElement(), note);
                    continue;
                }
                phrase.addNote(note);
                continue;
            }
            phrase.addNote(note);
        }
        if (dArray[dArray.length - 1][1] < 0.0) {
            dArray[dArray.length - 1][1] = 0.0;
        }
        if (dArray[dArray.length - 1][1] > 127.0) {
            dArray[dArray.length - 1][1] = 127.0;
        }
        Note note = new Note((int)dArray[dArray.length - 1][1], dArray[dArray.length - 1][2]);
        note.setDuration(dArray[dArray.length - 1][2]);
        phrase.addNote(note);
        if (phrase != null) {
            ++this.currentChannel;
            if (this.currentChannel > 15) {
                this.currentChannel = this.scoreChannels;
            }
            Part part = new Part("Sketch Part", 0, this.currentChannel);
            part.addPhrase(phrase);
            this.score.addPart(part);
        }
    }

    private void quickSort(double[][] dArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        SketchScoreArea.swap(dArray, n, (int)(Math.random() * (double)(n2 - n)) + n);
        int n3 = n;
        for (int i = n + 1; i <= n2; ++i) {
            if (!(dArray[i][0] <= dArray[n][0])) continue;
            SketchScoreArea.swap(dArray, ++n3, i);
        }
        SketchScoreArea.swap(dArray, n, n3);
        this.quickSort(dArray, n, n3 - 1);
        this.quickSort(dArray, n3 + 1, n2);
    }

    static void swap(double[][] dArray, int n, int n2) {
        for (int i = 0; i < 3; ++i) {
            double d = dArray[n][i];
            dArray[n][i] = dArray[n2][i];
            dArray[n2][i] = d;
        }
    }
}

