/*
 * Decompiled with CFR 0.152.
 */
package jm.gui.wave;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jm.gui.wave.WaveScrollPanel;

public class WaveRuler
extends Panel
implements MouseListener,
MouseMotionListener {
    private WaveScrollPanel scrollPanel;
    private int markerWidth;
    private int startX;
    private double tempRes;
    private Font font = new Font("Helvetica", 0, 9);
    private int startSecond = 0;

    public WaveRuler() {
        this.setBackground(Color.lightGray);
        this.setSize(new Dimension(800, 20));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setWaveScrollPanel(WaveScrollPanel waveScrollPanel) {
        this.scrollPanel = waveScrollPanel;
    }

    public void setMarkerWidth(int n) {
        if (n > 0) {
            this.markerWidth = n;
            this.repaint();
        }
    }

    public void paint(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        graphics.setColor(Color.darkGray);
        graphics.setFont(this.font);
        int n5 = this.getSize().width;
        int n6 = -1 * this.scrollPanel.getWaveView().getStartPos();
        int n7 = this.markerWidth;
        int n8 = (int)Math.round((double)this.markerWidth / 10.0);
        int n9 = (int)Math.round((double)this.markerWidth / 100.0);
        int n10 = (int)Math.round((double)this.markerWidth / 1000.0);
        int n11 = this.scrollPanel.getWaveView().getResolution();
        this.startSecond = this.scrollPanel.getWaveView().getStartPos() / this.scrollPanel.getWaveView().getSampleRate() / this.scrollPanel.getWaveView().getChannels();
        int n12 = 0;
        graphics.setColor(Color.white);
        if (this.markerWidth > 20000) {
            for (n4 = n6 / n11; n4 < n5; n4 += n7) {
                for (n3 = 0; n3 < 10; ++n3) {
                    for (n2 = 0; n2 < 10; ++n2) {
                        for (n = 0; n < 10; ++n) {
                            if (n12 % 10 != 0) {
                                int n13 = n4 + n3 * n8 + n2 * n9 + n * n10;
                                graphics.drawLine(n13, this.getSize().height / 8 * 7, n13, this.getSize().height);
                                if (this.markerWidth > 40000) {
                                    graphics.drawString("" + ((double)this.startSecond + (double)n12 / 1000.0), n13 + 2, this.getSize().height - 1);
                                }
                            }
                            ++n12;
                        }
                    }
                }
            }
        }
        n12 = 0;
        graphics.setColor(Color.magenta);
        if (this.markerWidth > 1200) {
            for (n4 = n6 / n11; n4 < n5; n4 += n7) {
                for (n3 = 0; n3 < 10; ++n3) {
                    for (n2 = 0; n2 < 10; ++n2) {
                        if (n12 % 10 != 0) {
                            n = n4 + n3 * n8 + n2 * n9;
                            graphics.drawLine(n, this.getSize().height / 4 * 3, n, this.getSize().height);
                            if (this.markerWidth > 4800) {
                                graphics.drawString("" + ((double)this.startSecond + (double)n12 / 100.0), n + 2, this.getSize().height - 1);
                            }
                        }
                        ++n12;
                    }
                }
            }
        }
        n12 = 0;
        graphics.setColor(Color.blue);
        if (this.markerWidth > 150) {
            for (n4 = n6 / n11; n4 < n5; n4 += n7) {
                for (n3 = 0; n3 < 10; ++n3) {
                    if (n12 % 10 != 0) {
                        n2 = n4 + n3 * n8;
                        graphics.drawLine(n2, this.getSize().height / 2, n2, this.getSize().height);
                        if (this.markerWidth > 300) {
                            graphics.drawString("" + ((double)this.startSecond + (double)n12 / 10.0), n2 + 2, this.getSize().height - 1);
                        }
                    }
                    ++n12;
                }
            }
        }
        n12 = 0;
        graphics.setColor(Color.red);
        for (n4 = n6 / n11; n4 < n5; n4 += n7) {
            graphics.drawLine(n4, 1, n4, this.getSize().height);
            if (this.markerWidth > 20 && this.markerWidth <= 300) {
                graphics.drawString("" + (this.startSecond + n12), n4 + 2, this.getSize().height - 1);
            } else if (this.markerWidth > 300) {
                graphics.drawString("" + ((double)this.startSecond + (double)n12 / 1.0), n4 + 2, this.getSize().height - 1);
            }
            ++n12;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(10));
        this.startX = mouseEvent.getX();
        this.tempRes = this.scrollPanel.getWaveView().getResolution();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(13));
        this.scrollPanel.getWaveView().setResolution((int)this.tempRes);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = 5;
        if (mouseEvent.getX() > this.startX + n) {
            this.tempRes = this.tempRes < 8.0 ? (double)Math.round(this.tempRes / 2.0) : (double)Math.round(this.tempRes / 1.1);
            if (this.tempRes < 1.0) {
                this.tempRes = 1.0;
            }
            if (this.tempRes > 2048.0) {
                this.tempRes = 2048.0;
            }
            this.scrollPanel.setResolution((int)Math.round(this.tempRes));
            this.startX = mouseEvent.getX();
            this.repaint();
        }
        if (mouseEvent.getX() < this.startX - n) {
            this.tempRes = this.tempRes < 8.0 ? (double)Math.round(this.tempRes * 2.0) : (double)Math.round(this.tempRes * 1.1);
            if (this.tempRes < 1.0) {
                this.tempRes = 1.0;
            }
            if (this.tempRes > 2048.0) {
                this.tempRes = 2048.0;
            }
            this.scrollPanel.setResolution((int)Math.round(this.tempRes));
            this.startX = mouseEvent.getX();
            this.repaint();
        }
    }
}

